/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.tags;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.jsp.JspException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.wiki.api.exceptions.ProviderException;
import org.apache.wiki.tags.WikiTagBase;
import org.apache.wiki.ui.TemplateManager;
import org.apache.wiki.util.TextUtil;

public class IncludeTag
extends WikiTagBase {
    private static final long serialVersionUID = 0L;
    private static final Logger LOG = LogManager.getLogger(IncludeTag.class);
    protected String m_page;

    @Override
    public void initTag() {
        super.initTag();
        this.m_page = null;
    }

    public void setPage(String page) {
        this.m_page = page;
    }

    public String getPage() {
        return this.m_page;
    }

    @Override
    public final int doWikiStartTag() throws IOException, ProviderException {
        return 0;
    }

    @Override
    public final int doEndTag() throws JspException {
        try {
            String page = ((TemplateManager)this.m_wikiContext.getEngine().getManager(TemplateManager.class)).findJSP(this.pageContext, this.m_wikiContext.getTemplate(), this.m_page);
            if (page == null) {
                this.pageContext.getOut().println("No template file called '" + TextUtil.replaceEntities((String)this.m_page) + "'");
            } else {
                this.pageContext.include(page);
            }
        }
        catch (ServletException e) {
            LOG.warn("Including failed, got a servlet exception from sub-page. Rethrowing the exception to the JSP engine.", (Throwable)e);
            throw new JspException(e.getMessage());
        }
        catch (IOException e) {
            LOG.warn("I/O exception - probably the connection was broken. Rethrowing the exception to the JSP engine.", (Throwable)e);
            throw new JspException(e.getMessage());
        }
        return 6;
    }
}

