/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.csv;

import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import java.util.List;
import org.apache.juneau.BeanMap;
import org.apache.juneau.BeanMeta;
import org.apache.juneau.BeanPropertyMeta;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.DefaultFilteringObjectMap;
import org.apache.juneau.ObjectMap;
import org.apache.juneau.csv.CsvSerializer;
import org.apache.juneau.serializer.SerializeException;
import org.apache.juneau.serializer.SerializerPipe;
import org.apache.juneau.serializer.SerializerSessionArgs;
import org.apache.juneau.serializer.WriterSerializerSession;

public final class CsvSerializerSession
extends WriterSerializerSession {
    protected CsvSerializerSession(CsvSerializer ctx, SerializerSessionArgs args) {
        super(ctx, args);
    }

    @Override
    protected final void doSerialize(SerializerPipe pipe, Object o) throws IOException, SerializeException {
        try (Writer w = pipe.getWriter();){
            ClassMeta entryType;
            ClassMeta<Object> cm = this.getClassMetaForObject(o);
            List<Object> l = null;
            l = cm.isArray() ? Arrays.asList((Object[])o) : (List<Object>)o;
            if (l.size() > 0 && (entryType = this.getClassMetaForObject(l.iterator().next())).isBean()) {
                BeanMeta bm = entryType.getBeanMeta();
                int i = 0;
                for (BeanPropertyMeta beanPropertyMeta : bm.getPropertyMetas()) {
                    if (!beanPropertyMeta.canRead()) continue;
                    if (i++ > 0) {
                        w.append(',');
                    }
                    CsvSerializerSession.append(w, beanPropertyMeta.getName());
                }
                w.append('\n');
                for (BeanPropertyMeta beanPropertyMeta : l) {
                    i = 0;
                    BeanMap<BeanPropertyMeta> bean = this.toBeanMap(beanPropertyMeta);
                    for (BeanPropertyMeta pm : bm.getPropertyMetas()) {
                        if (!pm.canRead()) continue;
                        if (i++ > 0) {
                            w.append(',');
                        }
                        CsvSerializerSession.append(w, pm.get(bean, pm.getName()));
                    }
                    w.append('\n');
                }
            }
        }
    }

    private static void append(Writer w, Object o) throws IOException {
        if (o == null) {
            w.append("null");
        } else {
            String s = o.toString();
            boolean mustQuote = false;
            for (int i = 0; i < s.length() && !mustQuote; ++i) {
                char c = s.charAt(i);
                if (!Character.isWhitespace(c) && c != ',') continue;
                mustQuote = true;
            }
            if (mustQuote) {
                w.append('\"').append(s).append('\"');
            } else {
                w.append(s);
            }
        }
    }

    @Override
    public ObjectMap toMap() {
        return super.toMap().append("CsvSerializerSession", new DefaultFilteringObjectMap());
    }
}

