/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.internal;

import java.io.BufferedReader;
import java.io.StringReader;

public final class CharSequenceReader
extends BufferedReader {
    private final CharSequence cs;
    private String s;
    private StringBuffer sb;
    private StringBuilder sb2;
    private int length;
    private int next = 0;

    public CharSequenceReader(CharSequence cs) {
        super(new StringReader(""), 1);
        if (cs == null) {
            cs = "";
        }
        this.cs = cs;
        if (cs instanceof String) {
            this.s = (String)cs;
        } else if (cs instanceof StringBuffer) {
            this.sb = (StringBuffer)cs;
        } else if (cs instanceof StringBuilder) {
            this.sb2 = (StringBuilder)cs;
        }
        this.length = cs.length();
    }

    @Override
    public int read() {
        if (this.next >= this.length) {
            return -1;
        }
        return this.cs.charAt(this.next++);
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public int read(char[] cbuf, int off, int len) {
        if (this.next >= this.length) {
            return -1;
        }
        int n = Math.min(this.length - this.next, len);
        if (this.s != null) {
            this.s.getChars(this.next, this.next + n, cbuf, off);
        } else if (this.sb != null) {
            this.sb.getChars(this.next, this.next + n, cbuf, off);
        } else if (this.sb2 != null) {
            this.sb2.getChars(this.next, this.next + n, cbuf, off);
        } else {
            for (int i = 0; i < n; ++i) {
                cbuf[off + i] = this.cs.charAt(this.next + i);
            }
        }
        this.next += n;
        return n;
    }

    @Override
    public long skip(long ns) {
        if (this.next >= this.length) {
            return 0L;
        }
        long n = Math.min((long)(this.length - this.next), ns);
        n = Math.max((long)(-this.next), n);
        this.next = (int)((long)this.next + n);
        return n;
    }

    @Override
    public void close() {
    }

    public String toString() {
        return this.cs.toString();
    }
}

