/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.csv;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.juneau.BeanPropertyMeta;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.DefaultFilteringObjectMap;
import org.apache.juneau.ObjectMap;
import org.apache.juneau.PropertyStore;
import org.apache.juneau.annotation.ConfigurableContext;
import org.apache.juneau.csv.CsvBeanPropertyMeta;
import org.apache.juneau.csv.CsvClassMeta;
import org.apache.juneau.csv.CsvCommon;
import org.apache.juneau.csv.CsvMetaProvider;
import org.apache.juneau.csv.CsvParserBuilder;
import org.apache.juneau.csv.CsvParserSession;
import org.apache.juneau.parser.ParserSessionArgs;
import org.apache.juneau.parser.ReaderParser;

@ConfigurableContext
public class CsvParser
extends ReaderParser
implements CsvMetaProvider,
CsvCommon {
    static final String PREFIX = "CsvParser";
    public static final CsvParser DEFAULT = new CsvParser(PropertyStore.DEFAULT);
    private final Map<ClassMeta<?>, CsvClassMeta> csvClassMetas = new ConcurrentHashMap();
    private final Map<BeanPropertyMeta, CsvBeanPropertyMeta> csvBeanPropertyMetas = new ConcurrentHashMap<BeanPropertyMeta, CsvBeanPropertyMeta>();

    public CsvParser(PropertyStore ps) {
        super(ps, "text/csv");
    }

    @Override
    public CsvParserBuilder builder() {
        return new CsvParserBuilder(this.getPropertyStore());
    }

    public static CsvParserBuilder create() {
        return new CsvParserBuilder();
    }

    @Override
    public CsvParserSession createSession() {
        return this.createSession(this.createDefaultSessionArgs());
    }

    @Override
    public CsvParserSession createSession(ParserSessionArgs args) {
        return new CsvParserSession(this, args);
    }

    @Override
    public CsvClassMeta getCsvClassMeta(ClassMeta<?> cm) {
        CsvClassMeta m = this.csvClassMetas.get(cm);
        if (m == null) {
            m = new CsvClassMeta(cm, this);
            this.csvClassMetas.put(cm, m);
        }
        return m;
    }

    @Override
    public CsvBeanPropertyMeta getCsvBeanPropertyMeta(BeanPropertyMeta bpm) {
        if (bpm == null) {
            return CsvBeanPropertyMeta.DEFAULT;
        }
        CsvBeanPropertyMeta m = this.csvBeanPropertyMetas.get(bpm);
        if (m == null) {
            m = new CsvBeanPropertyMeta(bpm.getDelegateFor(), this);
            this.csvBeanPropertyMetas.put(bpm, m);
        }
        return m;
    }

    @Override
    public ObjectMap toMap() {
        return super.toMap().append(PREFIX, new DefaultFilteringObjectMap());
    }
}

