/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.serializer;

import java.io.IOException;
import java.io.Writer;
import java.util.StringTokenizer;
import org.apache.juneau.UriResolver;

public class SerializerWriter
extends Writer {
    protected final Writer out;
    protected final boolean useWhitespace;
    protected final int maxIndent;
    protected final boolean trimStrings;
    protected final char quoteChar;
    protected final UriResolver uriResolver;

    public SerializerWriter(Writer out, boolean useWhitespace, int maxIndent, boolean trimStrings, char quoteChar, UriResolver uriResolver) {
        this.out = out;
        this.useWhitespace = useWhitespace;
        this.maxIndent = maxIndent;
        this.trimStrings = trimStrings;
        this.quoteChar = quoteChar;
        this.uriResolver = uriResolver;
    }

    public SerializerWriter cr(int depth) throws IOException {
        if (this.useWhitespace && depth <= this.maxIndent) {
            return this.nl(depth).i(depth);
        }
        return this;
    }

    public SerializerWriter cre(int depth) throws IOException {
        if (this.useWhitespace && depth <= this.maxIndent - 1) {
            return this.nl(depth).i(depth);
        }
        return this;
    }

    public SerializerWriter appendln(int indent, String text) throws IOException {
        return this.append(indent, true, text);
    }

    public SerializerWriter appendln(String text) throws IOException {
        return this.append(0, true, text);
    }

    public SerializerWriter append(int indent, String text) throws IOException {
        return this.append(indent, false, text);
    }

    public SerializerWriter append(int indent, char c) throws IOException {
        return this.i(indent).append(c);
    }

    private SerializerWriter append(int indent, boolean newline, String text) throws IOException {
        if (text.indexOf(10) != -1 && this.useWhitespace && indent <= this.maxIndent) {
            StringTokenizer st = new StringTokenizer(text, "\n");
            while (st.hasMoreTokens()) {
                this.i(indent);
                this.out.write(st.nextToken());
                this.out.write("\n");
            }
        } else {
            this.i(indent);
            this.out.write(text);
        }
        if (newline) {
            this.nl(indent);
        }
        return this;
    }

    public SerializerWriter appendUri(Object uri) throws IOException {
        this.uriResolver.append(this, uri);
        return this;
    }

    public SerializerWriter append(char[] characters) throws IOException {
        for (char c : characters) {
            this.append(c);
        }
        return this;
    }

    public SerializerWriter s() throws IOException {
        if (this.useWhitespace) {
            this.out.write(32);
        }
        return this;
    }

    public SerializerWriter q() throws IOException {
        this.out.write(this.quoteChar);
        return this;
    }

    public SerializerWriter i(int indent) throws IOException {
        if (this.useWhitespace && indent <= this.maxIndent) {
            for (int i = 0; i < indent; ++i) {
                this.out.write(9);
            }
        }
        return this;
    }

    public SerializerWriter ie(int indent) throws IOException {
        if (this.useWhitespace && indent <= this.maxIndent - 1) {
            for (int i = 0; i < indent; ++i) {
                this.out.write(9);
            }
        }
        return this;
    }

    public SerializerWriter nl(int indent) throws IOException {
        if (this.useWhitespace && indent <= this.maxIndent) {
            this.out.write(10);
        }
        return this;
    }

    public SerializerWriter sIf(boolean b) throws IOException {
        if (b && !this.useWhitespace) {
            this.out.write(32);
        }
        return this;
    }

    public SerializerWriter nlIf(boolean b, int indent) throws IOException {
        if (b && this.useWhitespace && indent <= this.maxIndent) {
            this.out.write(10);
        }
        return this;
    }

    public SerializerWriter append(Object text) throws IOException {
        this.out.append(text == null ? null : text.toString());
        return this;
    }

    public SerializerWriter append(String text) throws IOException {
        if (text != null) {
            this.out.append(text);
        }
        return this;
    }

    public SerializerWriter appendIf(boolean b, String text) throws IOException {
        if (b) {
            this.out.write(text);
        }
        return this;
    }

    public SerializerWriter appendIf(boolean b, char c) throws IOException {
        if (b) {
            this.out.write(c);
        }
        return this;
    }

    @Override
    public SerializerWriter append(char c) throws IOException {
        this.out.write(c);
        return this;
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        this.out.write(cbuf, off, len);
    }

    @Override
    public void flush() throws IOException {
        this.out.flush();
    }

    @Override
    public void close() throws IOException {
        this.out.close();
    }
}

