/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.http;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.juneau.Streamable;
import org.apache.juneau.http.MediaType;
import org.apache.juneau.http.annotation.Response;
import org.apache.juneau.http.annotation.ResponseBody;
import org.apache.juneau.http.annotation.ResponseHeader;
import org.apache.juneau.internal.CollectionUtils;
import org.apache.juneau.internal.IOUtils;

@Response
public class StreamResource
implements Streamable {
    private final MediaType mediaType;
    private final Object[] contents;
    private final Map<String, Object> headers;

    StreamResource(Builder b) throws IOException {
        this(b.mediaType, b.headers, b.cached, b.contents.toArray());
    }

    public StreamResource(MediaType mediaType, Map<String, Object> headers, boolean cached, Object ... contents) throws IOException {
        Object[] objectArray;
        this.mediaType = mediaType;
        this.headers = CollectionUtils.immutableMap(headers);
        if (cached) {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = IOUtils.readBytes(contents);
        } else {
            objectArray = contents;
        }
        this.contents = objectArray;
    }

    public static Builder create() {
        return new Builder();
    }

    @ResponseHeader(value="*")
    public Map<String, Object> getHeaders() {
        return this.headers;
    }

    @Override
    @ResponseBody
    public void streamTo(OutputStream os) throws IOException {
        for (Object c : this.contents) {
            IOUtils.pipe(c, os);
        }
        os.flush();
    }

    @Override
    @ResponseHeader(value="Content-Type")
    public MediaType getMediaType() {
        return this.mediaType;
    }

    public InputStream getContents() throws IOException {
        Object c;
        if (this.contents.length == 1 && (c = this.contents[0]) != null) {
            if (c instanceof byte[]) {
                return new ByteArrayInputStream((byte[])c);
            }
            if (c instanceof InputStream) {
                return (InputStream)c;
            }
            if (c instanceof File) {
                return new FileInputStream((File)c);
            }
            if (c instanceof CharSequence) {
                return new ByteArrayInputStream(((CharSequence)c).toString().getBytes(IOUtils.UTF8));
            }
        }
        byte[][] bc = new byte[this.contents.length][];
        int c2 = 0;
        for (int i = 0; i < this.contents.length; ++i) {
            Object o = this.contents[i];
            if (o == null) {
                bc[i] = new byte[0];
            } else if (o instanceof byte[]) {
                bc[i] = (byte[])o;
            } else if (o instanceof InputStream) {
                bc[i] = IOUtils.readBytes((InputStream)o, 1024);
            } else if (o instanceof Reader) {
                bc[i] = IOUtils.read((Reader)o).getBytes(IOUtils.UTF8);
            } else if (o instanceof File) {
                bc[i] = IOUtils.readBytes((File)o);
            } else if (o instanceof CharSequence) {
                bc[i] = ((CharSequence)o).toString().getBytes(IOUtils.UTF8);
            }
            c2 += bc[i].length;
        }
        ByteBuffer bb = ByteBuffer.allocate(c2);
        for (byte[] b : bc) {
            bb.put(b);
        }
        return new ByteArrayInputStream(bb.array());
    }

    public static class Builder {
        ArrayList<Object> contents = new ArrayList();
        MediaType mediaType;
        Map<String, Object> headers = new LinkedHashMap<String, Object>();
        boolean cached;

        public Builder mediaType(String mediaType) {
            this.mediaType = MediaType.forString(mediaType);
            return this;
        }

        public Builder mediaType(MediaType mediaType) {
            this.mediaType = mediaType;
            return this;
        }

        public Builder contents(Object ... contents) {
            this.contents.addAll(Arrays.asList(contents));
            return this;
        }

        public Builder header(String name, Object value) {
            this.headers.put(name, value);
            return this;
        }

        public Builder headers(Map<String, Object> headers) {
            this.headers.putAll(headers);
            return this;
        }

        public Builder cached() {
            this.cached = true;
            return this;
        }

        public StreamResource build() throws IOException {
            return new StreamResource(this);
        }
    }
}

