/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest.client;

import org.apache.http.HttpResponse;

public abstract class RetryOn {
    public static final RetryOn DEFAULT = new RetryOn(){

        @Override
        public boolean onCode(int httpResponseCode) {
            return httpResponseCode <= 0 || httpResponseCode >= 400;
        }
    };
    public static final RetryOn CONNECTION_LOST = new RetryOn(){

        @Override
        public boolean onCode(int httpResponseCode) {
            return httpResponseCode <= 0;
        }
    };

    protected boolean onResponse(HttpResponse response) {
        return this.onCode(response == null || response.getStatusLine() == null ? -1 : response.getStatusLine().getStatusCode());
    }

    protected boolean onCode(int httpResponseCode) {
        return false;
    }
}

