/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.utils;

import java.util.concurrent.ConcurrentHashMap;
import org.apache.juneau.utils.IdGenerator;
import org.apache.juneau.utils.IdGenerators;

public class IdMap<K, V>
extends ConcurrentHashMap<K, V> {
    private static final long serialVersionUID = 1L;
    private final IdGenerator<K> idGen;

    public static <T> IdMap<Integer, T> createIntMap(Class<T> c) {
        return IdMap.createIntMap(c, 1);
    }

    public static <T> IdMap<Integer, T> createIntMap(Class<T> c, int initValue) {
        return IdMap.create(c, IdGenerators.createIntGenerator(initValue));
    }

    public static <T> IdMap<Long, T> createLongMap(Class<T> c) {
        return IdMap.createLongMap(c, 1L);
    }

    public static <T> IdMap<Long, T> createLongMap(Class<T> c, long initValue) {
        return IdMap.create(c, IdGenerators.createLongGenerator(initValue));
    }

    public static <K, T> IdMap<K, T> create(Class<T> c, IdGenerator<K> idGen) {
        return new IdMap<K, T>(c, idGen);
    }

    private IdMap(Class<V> c, IdGenerator<K> idGen) {
        this.idGen = idGen;
    }

    public K nextId() {
        return this.idGen.next();
    }

    public void lbId(K k) {
        this.idGen.lb(k);
    }
}

