/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest.vars;

import org.apache.juneau.http.ReaderResource;
import org.apache.juneau.rest.RestRequest;
import org.apache.juneau.svl.DefaultingVar;
import org.apache.juneau.svl.VarResolverSession;
import org.apache.juneau.utils.ClasspathResourceManager;

public class FileVar
extends DefaultingVar {
    private static final String SESSION_req = "req";
    private static final String SESSION_crm = "crm";
    public static final String NAME = "F";

    public FileVar() {
        super(NAME);
    }

    public String resolve(VarResolverSession session, String key) throws Exception {
        RestRequest req = (RestRequest)((Object)session.getSessionObject(RestRequest.class, SESSION_req, false));
        if (req != null) {
            ReaderResource rr = req.getClasspathReaderResource(key);
            return rr == null ? null : rr.toCommentStrippedString();
        }
        ClasspathResourceManager crm = (ClasspathResourceManager)session.getSessionObject(ClasspathResourceManager.class, SESSION_crm, false);
        if (crm != null) {
            return crm.getString(key);
        }
        return null;
    }

    public boolean canResolve(VarResolverSession session) {
        return session.hasSessionObject(SESSION_req) || session.hasSessionObject(SESSION_crm);
    }
}

