/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.internal;

import java.lang.reflect.Array;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.Consumer;
import org.apache.juneau.internal.ListBuilder;
import org.apache.juneau.internal.MapBuilder;
import org.apache.juneau.internal.SetBuilder;

public final class CollectionUtils {
    public static <E> Set<E> setFrom(Collection<E> val) {
        return val == null ? null : new LinkedHashSet<E>(val);
    }

    public static <E> Set<E> copyOf(Set<E> val) {
        return val == null ? null : new LinkedHashSet<E>(val);
    }

    public static <E> Collection<E> copyOf(Collection<E> val) {
        return val == null ? null : new LinkedHashSet<E>(val);
    }

    public static <K, V> Map<K, V> copyOf(Map<K, V> val) {
        return val == null ? null : new LinkedHashMap<K, V>(val);
    }

    public static <K, V> MapBuilder<K, V> mapBuilder(Map<K, V> addTo) {
        return new MapBuilder<K, V>(addTo);
    }

    public static <K, V> MapBuilder<K, V> mapBuilder(Class<K> keyType, Class<V> valueType, Type ... valueTypeArgs) {
        return new MapBuilder<K, V>(keyType, valueType, valueTypeArgs);
    }

    public static <E> ListBuilder<E> listBuilder(List<E> addTo) {
        return new ListBuilder<E>(addTo);
    }

    public static <E> ListBuilder<E> listBuilder(Class<E> elementType, Type ... elementTypeArgs) {
        return new ListBuilder<E>(elementType, elementTypeArgs);
    }

    public static <E> SetBuilder<E> setBuilder(Set<E> addTo) {
        return new SetBuilder<E>(addTo);
    }

    public static <E> SetBuilder<E> setBuilder(Class<E> elementType, Type ... elementTypeArgs) {
        return new SetBuilder<E>(elementType, elementTypeArgs);
    }

    public static <E> List<E> emptyList() {
        return Collections.emptyList();
    }

    @SafeVarargs
    public static <E> ArrayList<E> list(E ... values) {
        ArrayList<E> l = new ArrayList<E>(values.length);
        for (E v : values) {
            l.add(v);
        }
        return l;
    }

    public static <E> ArrayList<E> list(int size) {
        return new ArrayList(size);
    }

    @SafeVarargs
    public static <E> LinkedList<E> linkedList(E ... values) {
        LinkedList<E> l = new LinkedList<E>();
        for (E v : values) {
            l.add(v);
        }
        return l;
    }

    @SafeVarargs
    public static <E> List<E> alist(E ... values) {
        if (values == null) {
            return null;
        }
        return Arrays.asList(values);
    }

    public static <E> ArrayList<E> listFrom(Collection<E> value) {
        return CollectionUtils.listFrom(value, false);
    }

    public static <K, V> LinkedHashMap<K, V> mapFrom(Map<K, V> value) {
        if (value == null) {
            return null;
        }
        return new LinkedHashMap<K, V>(value);
    }

    public static <E> ArrayList<E> listFrom(Collection<E> value, boolean nullIfEmpty) {
        if (value == null || nullIfEmpty && value.isEmpty()) {
            return null;
        }
        ArrayList l = new ArrayList();
        value.forEach(x -> l.add(x));
        return l;
    }

    @SafeVarargs
    public static <E> LinkedHashSet<E> set(E ... values) {
        LinkedHashSet<E> l = new LinkedHashSet<E>();
        for (E v : values) {
            l.add(v);
        }
        return l;
    }

    @SafeVarargs
    public static <E> Set<E> uset(E ... values) {
        return CollectionUtils.unmodifiable(CollectionUtils.set(values));
    }

    @SafeVarargs
    public static <E> List<E> ulist(E ... values) {
        if (values == null) {
            return null;
        }
        return CollectionUtils.unmodifiable(CollectionUtils.alist(values));
    }

    @SafeVarargs
    public static <E> TreeSet<E> sortedSet(E ... values) {
        TreeSet<E> l = new TreeSet<E>();
        for (E v : values) {
            l.add(v);
        }
        return l;
    }

    public static <E> TreeSet<E> sortedSetFrom(Collection<E> value) {
        if (value == null) {
            return null;
        }
        TreeSet l = new TreeSet();
        value.forEach(x -> l.add(x));
        return l;
    }

    public static <E> TreeSet<E> sortedSetFrom(Collection<E> value, boolean nullIfEmpty) {
        if (value == null || nullIfEmpty && value.isEmpty()) {
            return null;
        }
        TreeSet l = new TreeSet();
        value.forEach(x -> l.add(x));
        return l;
    }

    public static <K, V> LinkedHashMap<K, V> map() {
        LinkedHashMap m = new LinkedHashMap();
        return m;
    }

    public static <K, V> LinkedHashMap<K, V> map(K k1, V v1) {
        LinkedHashMap<K, V> m = new LinkedHashMap<K, V>();
        m.put(k1, v1);
        return m;
    }

    public static <K, V> LinkedHashMap<K, V> map(K k1, V v1, K k2, V v2) {
        LinkedHashMap<K, V> m = new LinkedHashMap<K, V>();
        m.put(k1, v1);
        m.put(k2, v2);
        return m;
    }

    public static <K, V> LinkedHashMap<K, V> map(K k1, V v1, K k2, V v2, K k3, V v3) {
        LinkedHashMap<K, V> m = new LinkedHashMap<K, V>();
        m.put(k1, v1);
        m.put(k2, v2);
        m.put(k3, v3);
        return m;
    }

    public static <K, V> TreeMap<K, V> sortedMap() {
        return new TreeMap();
    }

    public static <E> ArrayList<E> copyOf(List<E> value) {
        return value == null ? null : new ArrayList<E>(value);
    }

    @SafeVarargs
    public static <E> ArrayList<E> sortedList(E ... values) {
        ArrayList<E> l = CollectionUtils.list(values);
        Collections.sort(l);
        return l;
    }

    public static <E> ArrayList<E> sortedList(Comparator<E> comparator, E[] values) {
        ArrayList<E> l = CollectionUtils.list(values);
        Collections.sort(l, comparator);
        return l;
    }

    public static <E> ArrayList<E> sortedList(Comparator<E> comparator, Collection<E> value) {
        ArrayList<E> l = CollectionUtils.listFrom(value);
        Collections.sort(l, comparator);
        return l;
    }

    public static <E> List<E> unmodifiable(List<E> value) {
        return value == null ? null : Collections.unmodifiableList(value);
    }

    public static <E> Set<E> unmodifiable(Set<E> value) {
        return value == null ? null : Collections.unmodifiableSet(value);
    }

    public static <K, V> Map<K, V> unmodifiable(Map<K, V> value) {
        return value == null ? null : Collections.unmodifiableMap(value);
    }

    public static <E> List<E> synced(List<E> value) {
        return value == null ? null : Collections.synchronizedList(value);
    }

    public static <E> Set<E> synced(Set<E> value) {
        return value == null ? null : Collections.synchronizedSet(value);
    }

    public static <K, V> Map<K, V> synced(Map<K, V> value) {
        return value == null ? null : Collections.synchronizedMap(value);
    }

    public static <E> E[] array(Collection<E> value, Class<E> componentType) {
        if (value == null) {
            return null;
        }
        Object[] array = (Object[])Array.newInstance(componentType, value.size());
        return value.toArray(array);
    }

    public static <E> void forEachReverse(List<E> value, Consumer<E> action) {
        if (value instanceof ArrayList) {
            for (int i = value.size() - 1; i >= 0; --i) {
                action.accept(value.get(i));
            }
        } else {
            ListIterator<E> i = value.listIterator(value.size());
            while (i.hasPrevious()) {
                action.accept(i.previous());
            }
        }
    }

    public static <E> void forEachReverse(E[] value, Consumer<E> action) {
        for (int i = value.length - 1; i >= 0; --i) {
            action.accept(value[i]);
        }
    }

    @SafeVarargs
    public static <E> Set<E> addAll(Set<E> value, E ... entries) {
        if (entries != null) {
            if (value == null) {
                value = CollectionUtils.set(entries);
            } else {
                Collections.addAll(value, entries);
            }
        }
        return value;
    }

    @SafeVarargs
    public static <E> SortedSet<E> addAll(SortedSet<E> value, E ... entries) {
        if (entries != null) {
            if (value == null) {
                value = CollectionUtils.sortedSet(entries);
            } else {
                Collections.addAll(value, entries);
            }
        }
        return value;
    }

    @SafeVarargs
    public static <E> List<E> addAll(List<E> value, E ... entries) {
        if (entries != null) {
            if (value == null) {
                value = CollectionUtils.list(entries);
            } else {
                Collections.addAll(value, entries);
            }
        }
        return value;
    }

    @SafeVarargs
    public static <E> List<E> prependAll(List<E> value, E ... entries) {
        if (entries != null) {
            if (value == null) {
                value = CollectionUtils.list(entries);
            } else {
                value.addAll(0, CollectionUtils.alist(entries));
            }
        }
        return value;
    }

    public static <E> E last(List<E> l) {
        if (l == null || l.isEmpty()) {
            return null;
        }
        return l.get(l.size() - 1);
    }

    public static <E> E last(E[] l) {
        if (l == null || l.length == 0) {
            return null;
        }
        return l[l.length - 1];
    }

    public static <T> Optional<T> optional(T value) {
        return Optional.ofNullable(value);
    }

    public static <T> Optional<T> empty() {
        return Optional.empty();
    }

    public static <E> boolean isNotEmpty(Collection<E> value) {
        return value != null && !value.isEmpty();
    }

    public static <K, V> boolean isNotEmpty(Map<K, V> value) {
        return value != null && !value.isEmpty();
    }
}

