/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.jmx.blueprint;

import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashSet;
import javax.management.openmbean.ArrayType;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.TabularType;

public class Item {
    private final String name;
    private final String description;
    private final OpenType type;

    public Item(String name, String description, OpenType type, String ... restrictions) {
        this.name = name;
        this.description = description;
        this.type = type;
    }

    public static TabularType tabularType(String name, String description, CompositeType rowType, String ... index) {
        try {
            return new TabularType(name, description, rowType, index);
        }
        catch (OpenDataException e) {
            throw new RuntimeException(e);
        }
    }

    public static CompositeType compositeType(String name, String description, Item ... items) {
        return Item.extend(null, name, description, items);
    }

    public static CompositeType extend(CompositeType parent, String name, String description, Item ... items) {
        LinkedHashSet<Item> all = new LinkedHashSet<Item>();
        if (parent != null) {
            Iterator<String> i$ = parent.keySet().iterator();
            while (i$.hasNext()) {
                String nm;
                String key = nm = i$.next();
                all.add(new Item(nm, parent.getDescription(key), parent.getType(key), new String[0]));
            }
        }
        all.addAll(Arrays.asList(items));
        String[] names = new String[all.size()];
        String[] descriptions = new String[all.size()];
        OpenType[] types = new OpenType[all.size()];
        int n = 0;
        for (Item item : all) {
            names[n] = item.name;
            descriptions[n] = item.description;
            types[n] = item.type;
            ++n;
        }
        try {
            return new CompositeType(name, description, names, descriptions, types);
        }
        catch (OpenDataException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> ArrayType<T> arrayType(int dim, OpenType<T> elementType) {
        try {
            return new ArrayType(dim, elementType);
        }
        catch (OpenDataException e) {
            throw new RuntimeException(e);
        }
    }
}

