/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.eventadmin.impl.handler;

import java.security.AccessController;
import java.util.HashMap;
import javax.security.auth.Subject;
import org.apache.felix.eventadmin.impl.handler.EventHandlerTracker;
import org.apache.felix.eventadmin.impl.tasks.AsyncDeliverTasks;
import org.apache.felix.eventadmin.impl.tasks.DefaultThreadPool;
import org.apache.felix.eventadmin.impl.tasks.SyncDeliverTasks;
import org.osgi.framework.BundleContext;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;

public class EventAdminImpl
implements EventAdmin {
    private volatile EventHandlerTracker tracker;
    private final AsyncDeliverTasks m_postManager;
    private final SyncDeliverTasks m_sendManager;
    private EventHandlerTracker.Matcher[] m_ignoreTopics;
    private boolean addTimestamp;
    private boolean addSubject;
    static final String SUBJECT = "subject";

    public EventAdminImpl(BundleContext bundleContext, DefaultThreadPool syncPool, DefaultThreadPool asyncPool, int timeout, String[] ignoreTimeout, boolean requireTopic, String[] ignoreTopics, boolean addTimestamp, boolean addSubject) {
        this.checkNull(syncPool, "syncPool");
        this.checkNull(asyncPool, "asyncPool");
        this.addTimestamp = addTimestamp;
        this.addSubject = addSubject;
        this.tracker = new EventHandlerTracker(bundleContext);
        this.tracker.update(ignoreTimeout, requireTopic);
        this.tracker.open();
        this.m_sendManager = new SyncDeliverTasks(syncPool, timeout);
        this.m_postManager = new AsyncDeliverTasks(asyncPool, this.m_sendManager);
        this.m_ignoreTopics = EventHandlerTracker.createMatchers(ignoreTopics);
    }

    private EventHandlerTracker getTracker() {
        EventHandlerTracker localTracker = this.tracker;
        if (localTracker == null) {
            throw new IllegalStateException("The EventAdmin is stopped");
        }
        return localTracker;
    }

    private boolean checkTopic(Event event) {
        boolean result = true;
        if (this.m_ignoreTopics != null) {
            for (EventHandlerTracker.Matcher m : this.m_ignoreTopics) {
                if (!m.match(event.getTopic())) continue;
                result = false;
                break;
            }
        }
        return result;
    }

    private Event prepareEvent(Event event) {
        boolean needTimeStamp = this.addTimestamp && !event.containsProperty("timestamp");
        boolean needSubject = this.addSubject && !event.containsProperty(SUBJECT);
        Subject subject = null;
        if (needSubject) {
            subject = Subject.getSubject(AccessController.getContext());
            boolean bl = needSubject = subject != null;
        }
        if (needTimeStamp || needSubject) {
            String[] names = event.getPropertyNames();
            HashMap<String, Object> map = new HashMap<String, Object>(names.length + 1);
            for (int i = 0; i < names.length; ++i) {
                if ("event.topics".equals(names[i])) continue;
                map.put(names[i], event.getProperty(names[i]));
            }
            if (needTimeStamp) {
                map.put("timestamp", System.currentTimeMillis());
            }
            if (needSubject) {
                map.put(SUBJECT, subject);
            }
            event = new Event(event.getTopic(), map);
        }
        return event;
    }

    @Override
    public void postEvent(Event event) {
        if (this.checkTopic(event)) {
            this.m_postManager.execute(this.getTracker().getHandlers(event), this.prepareEvent(event));
        }
    }

    @Override
    public void sendEvent(Event event) {
        if (this.checkTopic(event)) {
            this.m_sendManager.execute(this.getTracker().getHandlers(event), this.prepareEvent(event), false);
        }
    }

    public void stop() {
        this.tracker.close();
        this.tracker = null;
    }

    public void update(int timeout, String[] ignoreTimeout, boolean requireTopic, String[] ignoreTopics, boolean addTimestamp, boolean addSubject) {
        this.addTimestamp = addTimestamp;
        this.addSubject = addSubject;
        this.tracker.close();
        this.tracker.update(ignoreTimeout, requireTopic);
        this.m_sendManager.update(timeout);
        this.tracker.open();
        this.m_ignoreTopics = EventHandlerTracker.createMatchers(ignoreTopics);
    }

    private void checkNull(Object object, String name) {
        if (null == object) {
            throw new NullPointerException(name + " may not be null");
        }
    }
}

