/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.shell.ssh;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import org.apache.sshd.common.util.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KnownHostsManager {
    Logger LOG = LoggerFactory.getLogger(KnownHostsManager.class);
    private final File knownHosts;

    public KnownHostsManager(File knownHosts) {
        this.knownHosts = knownHosts;
        this.knownHosts.getParentFile().mkdirs();
        if (!this.knownHosts.exists()) {
            try {
                knownHosts.createNewFile();
            }
            catch (IOException e) {
                throw new RuntimeException("Error creating file for known hosts at: " + knownHosts);
            }
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public PublicKey getKnownKey(SocketAddress remoteAddress, String checkAlgorithm) throws InvalidKeySpecException {
        FileReader fr = null;
        BufferedReader reader = null;
        try {
            fr = new FileReader(this.knownHosts);
            reader = new BufferedReader(fr);
            PublicKey publicKey = this.getKnownKeyInternal(remoteAddress, checkAlgorithm, reader);
            this.close(reader);
            this.close(fr);
            return publicKey;
        }
        catch (IOException e) {
            try {
                throw new RuntimeException("Error reading known_hosts " + this.knownHosts, e);
                catch (NoSuchAlgorithmException e2) {
                    throw new RuntimeException(e2);
                }
            }
            catch (Throwable throwable) {
                this.close(reader);
                this.close(fr);
                throw throwable;
            }
        }
    }

    private PublicKey getKnownKeyInternal(SocketAddress remoteAddress, String checkAlgorithm, BufferedReader reader) throws IOException, NoSuchAlgorithmException, InvalidKeySpecException {
        String checkServerAddress = this.getAddressString(remoteAddress);
        String line = reader.readLine();
        while (line != null) {
            String[] lineParts = line.split(" ");
            String serverAddress = lineParts[0];
            String algorithm = lineParts[1];
            if (checkServerAddress.equals(serverAddress) && checkAlgorithm.equals(algorithm)) {
                byte[] key = Base64.decodeBase64((byte[])lineParts[2].getBytes());
                KeyFactory keyFactory = KeyFactory.getInstance(algorithm);
                X509EncodedKeySpec keySpec = new X509EncodedKeySpec(key);
                return keyFactory.generatePublic(keySpec);
            }
            line = reader.readLine();
        }
        return null;
    }

    public void storeKeyForHost(SocketAddress remoteAddress, PublicKey serverKey) {
        FileWriter ps = null;
        BufferedWriter bw = null;
        try {
            ps = new FileWriter(this.knownHosts, true);
            bw = new BufferedWriter(ps);
            this.writeKey(bw, remoteAddress, serverKey);
            this.close(bw);
            this.close(ps);
        }
        catch (Exception e) {
            try {
                throw new RuntimeException("Error storing key for host" + remoteAddress, e);
            }
            catch (Throwable throwable) {
                this.close(bw);
                this.close(ps);
                throw throwable;
            }
        }
    }

    private void writeKey(BufferedWriter bw, SocketAddress remoteAddress, PublicKey serverKey) throws IOException {
        bw.append(this.getAddressString(remoteAddress));
        bw.append(" ");
        bw.append(serverKey.getAlgorithm());
        bw.append(" ");
        serverKey.getEncoded();
        bw.append(new String(Base64.encodeBase64((byte[])serverKey.getEncoded()), "UTF-8"));
        bw.append("\n");
    }

    String getAddressString(SocketAddress address) {
        if (address instanceof InetSocketAddress) {
            InetSocketAddress inetAddress = (InetSocketAddress)address;
            return String.format("%s,%s:%s", inetAddress.getHostName(), inetAddress.getAddress().getHostAddress(), inetAddress.getPort());
        }
        return "";
    }

    private void close(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException e) {
                this.LOG.warn("Error closing: " + e.getMessage(), (Throwable)e);
            }
        }
    }
}

