/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.sshd.SshBuilder;
import org.apache.sshd.common.AbstractFactoryManager;
import org.apache.sshd.common.Closeable;
import org.apache.sshd.common.Factory;
import org.apache.sshd.common.ForwardingFilter;
import org.apache.sshd.common.NamedFactory;
import org.apache.sshd.common.Session;
import org.apache.sshd.common.SshdSocketAddress;
import org.apache.sshd.common.io.DefaultIoServiceFactoryFactory;
import org.apache.sshd.common.io.IoAcceptor;
import org.apache.sshd.common.io.IoServiceFactory;
import org.apache.sshd.common.io.IoSession;
import org.apache.sshd.common.io.mina.MinaServiceFactory;
import org.apache.sshd.common.io.nio2.Nio2ServiceFactory;
import org.apache.sshd.common.session.AbstractSession;
import org.apache.sshd.common.util.OsUtils;
import org.apache.sshd.common.util.SecurityUtils;
import org.apache.sshd.common.util.ThreadUtils;
import org.apache.sshd.server.Command;
import org.apache.sshd.server.CommandFactory;
import org.apache.sshd.server.PasswordAuthenticator;
import org.apache.sshd.server.PublickeyAuthenticator;
import org.apache.sshd.server.ServerFactoryManager;
import org.apache.sshd.server.UserAuth;
import org.apache.sshd.server.auth.UserAuthKeyboardInteractive;
import org.apache.sshd.server.auth.UserAuthPassword;
import org.apache.sshd.server.auth.UserAuthPublicKey;
import org.apache.sshd.server.auth.gss.GSSAuthenticator;
import org.apache.sshd.server.auth.gss.UserAuthGSS;
import org.apache.sshd.server.command.ScpCommandFactory;
import org.apache.sshd.server.keyprovider.PEMGeneratorHostKeyProvider;
import org.apache.sshd.server.keyprovider.SimpleGeneratorHostKeyProvider;
import org.apache.sshd.server.session.ServerConnectionService;
import org.apache.sshd.server.session.ServerSession;
import org.apache.sshd.server.session.ServerUserAuthService;
import org.apache.sshd.server.session.SessionFactory;
import org.apache.sshd.server.sftp.SftpSubsystem;
import org.apache.sshd.server.shell.ProcessShellFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SshServer
extends AbstractFactoryManager
implements ServerFactoryManager,
Closeable {
    public static final Factory<SshServer> DEFAULT_SSH_SERVER_FACTORY = new Factory<SshServer>(){

        @Override
        public SshServer create() {
            return new SshServer();
        }
    };
    protected IoAcceptor acceptor;
    protected String host;
    protected int port;
    protected List<NamedFactory<UserAuth>> userAuthFactories;
    protected Factory<Command> shellFactory;
    protected SessionFactory sessionFactory;
    protected CommandFactory commandFactory;
    protected List<NamedFactory<Command>> subsystemFactories;
    protected PasswordAuthenticator passwordAuthenticator;
    protected PublickeyAuthenticator publickeyAuthenticator;
    protected GSSAuthenticator gssAuthenticator;

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    @Override
    public List<NamedFactory<UserAuth>> getUserAuthFactories() {
        return this.userAuthFactories;
    }

    public void setUserAuthFactories(List<NamedFactory<UserAuth>> userAuthFactories) {
        this.userAuthFactories = userAuthFactories;
    }

    @Override
    public Factory<Command> getShellFactory() {
        return this.shellFactory;
    }

    public void setShellFactory(Factory<Command> shellFactory) {
        this.shellFactory = shellFactory;
    }

    public SessionFactory getSessionFactory() {
        return this.sessionFactory;
    }

    public void setSessionFactory(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    @Override
    public CommandFactory getCommandFactory() {
        return this.commandFactory;
    }

    public void setCommandFactory(CommandFactory commandFactory) {
        this.commandFactory = commandFactory;
    }

    @Override
    public List<NamedFactory<Command>> getSubsystemFactories() {
        return this.subsystemFactories;
    }

    public void setSubsystemFactories(List<NamedFactory<Command>> subsystemFactories) {
        this.subsystemFactories = subsystemFactories;
    }

    @Override
    public PasswordAuthenticator getPasswordAuthenticator() {
        return this.passwordAuthenticator;
    }

    public void setPasswordAuthenticator(PasswordAuthenticator passwordAuthenticator) {
        this.passwordAuthenticator = passwordAuthenticator;
    }

    @Override
    public PublickeyAuthenticator getPublickeyAuthenticator() {
        return this.publickeyAuthenticator;
    }

    public void setPublickeyAuthenticator(PublickeyAuthenticator publickeyAuthenticator) {
        this.publickeyAuthenticator = publickeyAuthenticator;
    }

    @Override
    public GSSAuthenticator getGSSAuthenticator() {
        return this.gssAuthenticator;
    }

    public void setGSSAuthenticator(GSSAuthenticator gssAuthenticator) {
        this.gssAuthenticator = gssAuthenticator;
    }

    @Override
    public void setTcpipForwardingFilter(ForwardingFilter forwardingFilter) {
        this.tcpipForwardingFilter = forwardingFilter;
    }

    protected void checkConfig() {
        if (this.getPort() < 0) {
            throw new IllegalArgumentException("Bad port number: " + this.port);
        }
        if (this.getKeyExchangeFactories() == null) {
            throw new IllegalArgumentException("KeyExchangeFactories not set");
        }
        if (this.getUserAuthFactories() == null) {
            ArrayList<NamedFactory<UserAuth>> factories = new ArrayList<NamedFactory<UserAuth>>();
            if (this.getPasswordAuthenticator() != null) {
                factories.add(new UserAuthPassword.Factory());
                factories.add(new UserAuthKeyboardInteractive.Factory());
            }
            if (this.getPublickeyAuthenticator() != null) {
                factories.add(new UserAuthPublicKey.Factory());
            }
            if (this.getGSSAuthenticator() != null) {
                factories.add(new UserAuthGSS.Factory());
            }
            if (factories.size() > 0) {
                this.setUserAuthFactories(factories);
            } else {
                throw new IllegalArgumentException("UserAuthFactories not set");
            }
        }
        if (this.getScheduledExecutorService() == null) {
            this.setScheduledExecutorService(ThreadUtils.newSingleThreadScheduledExecutor(this.toString() + "-timer"), true);
        }
        if (this.getCipherFactories() == null) {
            throw new IllegalArgumentException("CipherFactories not set");
        }
        if (this.getCompressionFactories() == null) {
            throw new IllegalArgumentException("CompressionFactories not set");
        }
        if (this.getMacFactories() == null) {
            throw new IllegalArgumentException("MacFactories not set");
        }
        if (this.getChannelFactories() == null) {
            throw new IllegalArgumentException("ChannelFactories not set");
        }
        if (this.getRandomFactory() == null) {
            throw new IllegalArgumentException("RandomFactory not set");
        }
        if (this.getKeyPairProvider() == null) {
            throw new IllegalArgumentException("HostKeyProvider not set");
        }
        if (this.getFileSystemFactory() == null) {
            throw new IllegalArgumentException("FileSystemFactory not set");
        }
        if (this.getIoServiceFactoryFactory() == null) {
            this.setIoServiceFactoryFactory(new DefaultIoServiceFactoryFactory());
        }
        if (this.getServiceFactories() == null) {
            this.setServiceFactories(Arrays.asList(new ServerUserAuthService.Factory(), new ServerConnectionService.Factory()));
        }
    }

    public void start() throws IOException {
        this.checkConfig();
        if (this.sessionFactory == null) {
            this.sessionFactory = this.createSessionFactory();
        }
        this.sessionFactory.setServer(this);
        this.acceptor = this.createAcceptor();
        this.setupSessionTimeout(this.sessionFactory);
        if (this.host != null) {
            String[] hosts;
            for (String host : hosts = this.host.split(",")) {
                InetAddress[] inetAddresses;
                for (InetAddress inetAddress : inetAddresses = InetAddress.getAllByName(host)) {
                    this.acceptor.bind(new InetSocketAddress(inetAddress, this.port));
                    if (this.port != 0) continue;
                    this.port = ((InetSocketAddress)this.acceptor.getBoundAddresses().iterator().next()).getPort();
                }
            }
        } else {
            this.acceptor.bind(new InetSocketAddress(this.port));
            if (this.port == 0) {
                this.port = ((InetSocketAddress)this.acceptor.getBoundAddresses().iterator().next()).getPort();
            }
        }
    }

    public void stop() throws InterruptedException {
        this.stop(false);
    }

    public void stop(boolean immediately) throws InterruptedException {
        this.close(immediately).await();
    }

    public void open() throws IOException {
        this.start();
    }

    @Override
    protected Closeable getInnerCloseable() {
        return this.builder().run(new Runnable(){

            public void run() {
                SshServer.this.removeSessionTimeout(SshServer.this.sessionFactory);
            }
        }).sequential(this.acceptor, this.ioServiceFactory).run(new Runnable(){

            public void run() {
                SshServer.this.acceptor = null;
                SshServer.this.ioServiceFactory = null;
                if (SshServer.this.shutdownExecutor && SshServer.this.executor != null) {
                    SshServer.this.executor.shutdownNow();
                    SshServer.this.executor = null;
                }
            }
        }).build();
    }

    public List<AbstractSession> getActiveSessions() {
        ArrayList<AbstractSession> sessions = new ArrayList<AbstractSession>();
        for (IoSession ioSession : this.acceptor.getManagedSessions().values()) {
            AbstractSession session = AbstractSession.getSession(ioSession, true);
            if (session == null) continue;
            sessions.add(session);
        }
        return sessions;
    }

    protected IoAcceptor createAcceptor() {
        return this.getIoServiceFactory().createAcceptor(this.getSessionFactory());
    }

    protected SessionFactory createSessionFactory() {
        return new SessionFactory();
    }

    public String toString() {
        return "SshServer[" + Integer.toHexString(this.hashCode()) + "]";
    }

    public static SshServer setUpDefaultServer() {
        return (SshServer)SshBuilder.server().build();
    }

    public static void main(String[] args) throws Exception {
        int port = 8000;
        boolean error = false;
        LinkedHashMap<String, String> options = new LinkedHashMap<String, String>();
        for (int i = 0; i < args.length; ++i) {
            if ("-p".equals(args[i])) {
                if (i + 1 >= args.length) {
                    System.err.println("option requires an argument: " + args[i]);
                    break;
                }
                port = Integer.parseInt(args[++i]);
                continue;
            }
            if ("-io".equals(args[i])) {
                String provider;
                if (i + 1 >= args.length) {
                    System.err.println("option requires an argument: " + args[i]);
                    break;
                }
                if ("mina".equals(provider = args[++i])) {
                    System.setProperty(IoServiceFactory.class.getName(), MinaServiceFactory.class.getName());
                    continue;
                }
                if ("nio2".endsWith(provider)) {
                    System.setProperty(IoServiceFactory.class.getName(), Nio2ServiceFactory.class.getName());
                    continue;
                }
                System.err.println("provider should be mina or nio2: " + args[i]);
                break;
            }
            if ("-o".equals(args[i])) {
                String opt;
                int idx;
                if (i + 1 >= args.length) {
                    System.err.println("option requires and argument: " + args[i]);
                    error = true;
                    break;
                }
                if ((idx = (opt = args[++i]).indexOf(61)) <= 0) {
                    System.err.println("bad syntax for option: " + opt);
                    error = true;
                    break;
                }
                options.put(opt.substring(0, idx), opt.substring(idx + 1));
                continue;
            }
            if (args[i].startsWith("-")) {
                System.err.println("illegal option: " + args[i]);
                error = true;
                break;
            }
            System.err.println("extra argument: " + args[i]);
            error = true;
            break;
        }
        if (error) {
            System.err.println("usage: sshd [-p port] [-io mina|nio2] [-o option=value]");
            System.exit(-1);
        }
        System.err.println("Starting SSHD on port " + port);
        SshServer sshd = SshServer.setUpDefaultServer();
        sshd.getProperties().putAll(options);
        sshd.setPort(port);
        sshd.getProperties().put("welcome-banner", "Welcome to SSHD\n");
        if (SecurityUtils.isBouncyCastleRegistered()) {
            sshd.setKeyPairProvider(new PEMGeneratorHostKeyProvider("key.pem"));
        } else {
            sshd.setKeyPairProvider(new SimpleGeneratorHostKeyProvider("key.ser"));
        }
        if (OsUtils.isUNIX()) {
            sshd.setShellFactory(new ProcessShellFactory(new String[]{"/bin/sh", "-i", "-l"}, EnumSet.of(ProcessShellFactory.TtyOptions.ONlCr)));
        } else {
            sshd.setShellFactory(new ProcessShellFactory(new String[]{"cmd.exe "}, EnumSet.of(ProcessShellFactory.TtyOptions.Echo, ProcessShellFactory.TtyOptions.ICrNl, ProcessShellFactory.TtyOptions.ONlCr)));
        }
        sshd.setPasswordAuthenticator(new PasswordAuthenticator(){

            public boolean authenticate(String username, String password, ServerSession session) {
                return username != null && username.equals(password);
            }
        });
        sshd.setPublickeyAuthenticator(new PublickeyAuthenticator(){

            public boolean authenticate(String username, PublicKey key, ServerSession session) {
                return true;
            }
        });
        sshd.setTcpipForwardingFilter(new ForwardingFilter(){

            public boolean canForwardAgent(Session session) {
                return true;
            }

            public boolean canForwardX11(Session session) {
                return true;
            }

            public boolean canListen(SshdSocketAddress address, Session session) {
                return true;
            }

            public boolean canConnect(SshdSocketAddress address, Session session) {
                return true;
            }
        });
        sshd.setCommandFactory(new ScpCommandFactory(new CommandFactory(){

            public Command createCommand(String command) {
                EnumSet<ProcessShellFactory.TtyOptions> ttyOptions = OsUtils.isUNIX() ? EnumSet.of(ProcessShellFactory.TtyOptions.ONlCr) : EnumSet.of(ProcessShellFactory.TtyOptions.Echo, ProcessShellFactory.TtyOptions.ICrNl, ProcessShellFactory.TtyOptions.ONlCr);
                return new ProcessShellFactory(command.split(" "), ttyOptions).create();
            }
        }));
        sshd.setSubsystemFactories(Arrays.asList(new SftpSubsystem.Factory()));
        sshd.start();
        Thread.sleep(Long.MAX_VALUE);
    }
}

