/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.config.command;

import java.util.HashMap;
import java.util.Map;
import org.apache.karaf.config.command.ConfigCommandSupport;
import org.apache.karaf.config.command.completers.ConfigurationCompleter;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Completion;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Reference;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.apache.karaf.shell.support.table.ShellTable;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.metatype.AttributeDefinition;
import org.osgi.service.metatype.MetaTypeInformation;
import org.osgi.service.metatype.MetaTypeService;
import org.osgi.service.metatype.ObjectClassDefinition;

@Command(scope="config", name="meta", description="Lists meta type information.")
@Service
public class MetaCommand
extends ConfigCommandSupport {
    @Option(name="-p", aliases={"--pid"}, description="The configuration pid", required=true, multiValued=false)
    @Completion(value=ConfigurationCompleter.class)
    protected String pid;
    @Reference
    BundleContext context;
    private Map<Integer, String> typeMap = new HashMap<Integer, String>();

    public MetaCommand() {
        this.typeMap.put(11, "boolean");
        this.typeMap.put(6, "byte");
        this.typeMap.put(5, "char");
        this.typeMap.put(7, "double");
        this.typeMap.put(8, "float");
        this.typeMap.put(3, "int");
        this.typeMap.put(2, "long");
        this.typeMap.put(12, "password");
        this.typeMap.put(4, "short");
        this.typeMap.put(1, "String");
    }

    @Override
    public Object doExecute() throws Exception {
        try {
            new InnerCommand().doExecute();
        }
        catch (NoClassDefFoundError e) {
            System.out.println("No MetaTypeService present. You need to install an implementation to use this command.");
        }
        return null;
    }

    class InnerCommand {
        InnerCommand() {
        }

        protected Object doExecute() throws Exception {
            ServiceReference ref = MetaCommand.this.context.getServiceReference(MetaTypeService.class);
            if (ref == null) {
                System.out.println("No MetaTypeService present. You need to install an implementation to use this command.");
            }
            MetaTypeService metaTypeService = (MetaTypeService)MetaCommand.this.context.getService(ref);
            ObjectClassDefinition def = this.getMetatype(metaTypeService, MetaCommand.this.pid);
            MetaCommand.this.context.ungetService(ref);
            if (def == null) {
                System.out.println("No meta type definition found for pid: " + MetaCommand.this.pid);
                return null;
            }
            System.out.println("Meta type informations for pid: " + MetaCommand.this.pid);
            ShellTable table = new ShellTable();
            table.column("key");
            table.column("name");
            table.column("type");
            table.column("default");
            table.column("description");
            AttributeDefinition[] attrs = def.getAttributeDefinitions(-1);
            if (attrs != null) {
                for (AttributeDefinition attr : attrs) {
                    table.addRow().addContent(new Object[]{attr.getID(), attr.getName(), this.getType(attr.getType()), this.getDefaultValueStr(attr.getDefaultValue()), attr.getDescription()});
                }
            }
            table.print(System.out);
            return null;
        }

        private String getType(int type) {
            return (String)MetaCommand.this.typeMap.get(type);
        }

        private String getDefaultValueStr(String[] defaultValues) {
            if (defaultValues == null) {
                return "";
            }
            StringBuilder result = new StringBuilder();
            boolean first = true;
            for (String defaultValue : defaultValues) {
                if (first) {
                    first = false;
                } else {
                    result.append(",");
                }
                result.append(defaultValue);
            }
            return result.toString();
        }

        public ObjectClassDefinition getMetatype(MetaTypeService metaTypeService, String pid) {
            for (Bundle bundle : MetaCommand.this.context.getBundles()) {
                String[] pids;
                MetaTypeInformation info = metaTypeService.getMetaTypeInformation(bundle);
                if (info == null) continue;
                for (String cPid : pids = info.getPids()) {
                    if (!cPid.equals(pid)) continue;
                    return info.getObjectClassDefinition(cPid, null);
                }
            }
            return null;
        }
    }
}

