/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.shell.commands.impl;

import org.apache.karaf.shell.api.action.Action;
import org.apache.karaf.shell.api.action.Argument;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Command(scope="shell", name="sleep", description="Sleeps for a bit then wakes up.")
@Service
public class SleepAction
implements Action {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    @Argument(index=0, name="duration", description="The amount of time to sleep. The default time unit is millisecond, use -s option to use second instead.", required=true, multiValued=false)
    private long time = -1L;
    @Option(name="-s", aliases={"--second"}, description="Use a duration time in seconds instead of milliseconds.", required=false, multiValued=false)
    private boolean second = false;

    public Object execute() throws Exception {
        if (this.second) {
            this.log.info("Sleeping for {} second(s)", (Object)this.time);
            this.time *= 1000L;
        } else {
            this.log.info("Sleeping for {} millisecond(s)", (Object)this.time);
        }
        try {
            Thread.sleep(this.time);
        }
        catch (InterruptedException ignore) {
            this.log.debug("Sleep was interrupted... :-(");
        }
        this.log.info("Awake now");
        return null;
    }
}

