/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.packages.command;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.karaf.packages.core.PackageService;
import org.apache.karaf.packages.core.PackageVersion;
import org.apache.karaf.shell.api.action.Action;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Reference;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.apache.karaf.shell.support.table.Col;
import org.apache.karaf.shell.support.table.ShellTable;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Version;
import org.osgi.framework.wiring.BundleCapability;
import org.osgi.framework.wiring.BundleRevision;

@Command(scope="package", name="exports", description="Lists exported packages and the bundles that export them")
@Service
public class Exports
implements Action {
    @Option(name="-d", description="Only show packages that are exported by more than one bundle", required=false, multiValued=false)
    private boolean onlyDuplicates;
    @Option(name="--no-format", description="Disable table rendered output", required=false, multiValued=false)
    boolean noFormat;
    @Option(name="--show-name-only", description="Show only package name", required=false, multiValued=false)
    boolean showOnlyName = false;
    @Option(name="-b", description="Only show packages exported by given bundle id", required=false, multiValued=false)
    private Integer bundleId;
    @Option(name="-p", description="Only show package starting with given name", required=false, multiValued=false)
    private String packageFilter;
    @Reference
    private PackageService packageService;
    @Reference
    private BundleContext bundleContext;

    public Object execute() throws Exception {
        if (this.onlyDuplicates) {
            this.checkDuplicateExports();
        } else {
            this.showExports();
        }
        return null;
    }

    private void showExports() {
        List<PackageVersion> exports = this.packageService.getExports();
        ShellTable table = new ShellTable();
        table.column("Package Name");
        if (!this.showOnlyName) {
            table.column("Version");
            table.column("ID");
            table.column("Bundle Name");
        }
        for (PackageVersion pVer : exports) {
            for (Bundle bundle : pVer.getBundles()) {
                if (!this.matchesFilter(pVer, bundle)) continue;
                if (!this.showOnlyName) {
                    table.addRow().addContent(new Object[]{pVer.getPackageName(), pVer.getVersion().toString(), bundle.getBundleId(), bundle.getSymbolicName()});
                    continue;
                }
                table.addRow().addContent(new Object[]{pVer.getPackageName()});
            }
        }
        table.print(System.out, !this.noFormat);
    }

    private boolean matchesFilter(PackageVersion pVer, Bundle bundle) {
        return !(this.bundleId != null && bundle.getBundleId() != (long)this.bundleId.intValue() || this.packageFilter != null && !pVer.getPackageName().startsWith(this.packageFilter));
    }

    private void checkDuplicateExports() {
        Bundle[] bundles = this.bundleContext.getBundles();
        SortedMap<String, PackageVersion> packageVersionMap = this.getDuplicatePackages(bundles);
        ShellTable table = new ShellTable();
        table.column(new Col("Package Name"));
        table.column(new Col("Version"));
        table.column(new Col("Exporting bundles (ID)"));
        for (String key : packageVersionMap.keySet()) {
            PackageVersion pVer = (PackageVersion)packageVersionMap.get(key);
            if (pVer.getBundles().size() <= 1) continue;
            String pBundles = this.getBundlesSt(pVer.getBundles());
            table.addRow().addContent(new Object[]{pVer.getPackageName(), pVer.getVersion().toString(), pBundles});
        }
        table.print(System.out, !this.noFormat);
    }

    private String getBundlesSt(Set<Bundle> bundles) {
        StringBuilder st = new StringBuilder();
        for (Bundle bundle : bundles) {
            st.append(bundle.getBundleId() + " ");
        }
        return st.toString();
    }

    private SortedMap<String, PackageVersion> getDuplicatePackages(Bundle[] bundles) {
        TreeMap<String, PackageVersion> packageVersionMap = new TreeMap<String, PackageVersion>();
        for (Bundle bundle : bundles) {
            BundleRevision rev = (BundleRevision)bundle.adapt(BundleRevision.class);
            if (rev == null) continue;
            List caps = rev.getDeclaredCapabilities("osgi.wiring.package");
            for (BundleCapability cap : caps) {
                Map attr = cap.getAttributes();
                String packageName = (String)attr.get("osgi.wiring.package");
                Version version = (Version)attr.get("version");
                String key = packageName + ":" + version.toString();
                PackageVersion pVer = (PackageVersion)packageVersionMap.get(key);
                if (pVer == null) {
                    pVer = new PackageVersion(packageName, version);
                    packageVersionMap.put(key, pVer);
                }
                pVer.addBundle(bundle);
            }
        }
        return packageVersionMap;
    }
}

