/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.system.commands;

import java.io.File;
import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import org.apache.karaf.shell.api.action.Action;
import org.apache.karaf.shell.api.action.Argument;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Reference;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.apache.karaf.system.SystemService;
import org.osgi.framework.BundleContext;

@Command(scope="system", name="property", description="Get or set a system property.")
@Service
public class SystemProperty
implements Action {
    @Option(name="-p", aliases={"--persistent"}, description="Persist the new value to the etc/system.properties file")
    boolean persistent;
    @Option(name="-f", aliases={"--file-dump"}, description="Dump all system properties in a file (in data folder)")
    boolean dumpToFile;
    @Option(name="-u", aliases={"--unset"}, description="Show unset know properties with value unset")
    boolean unset;
    @Argument(index=0, name="key", required=false, description="The system property name")
    String key;
    @Argument(index=1, name="value", required=false, description="New value for the system property")
    String value;
    @Reference
    BundleContext bundleContext;
    @Reference
    SystemService systemService;

    public Object execute() throws Exception {
        if (this.key == null && this.value == null) {
            Properties props = (Properties)System.getProperties().clone();
            String def = null;
            if (this.unset) {
                def = "unset";
            }
            this.setProperty(props, "org.osgi.framework.startlevel.beginning", def);
            this.setProperty(props, "org.osgi.framework.bootdelegation", def);
            this.setProperty(props, "org.osgi.framework.bundle.parent", def);
            this.setProperty(props, "app", def);
            this.setProperty(props, "boot", def);
            this.setProperty(props, "ext", def);
            this.setProperty(props, "framework", def);
            this.setProperty(props, "org.osgi.framework.command.execpermission", def);
            this.setProperty(props, "org.osgi.framework.executionenvironment", def);
            this.setProperty(props, "org.osgi.framework.language", def);
            this.setProperty(props, "org.osgi.framework.library.extensions", def);
            this.setProperty(props, "org.osgi.framework.os.name", def);
            this.setProperty(props, "org.osgi.framework.os.version", def);
            this.setProperty(props, "org.osgi.framework.processor", def);
            this.setProperty(props, "org.osgi.framework.security", def);
            this.setProperty(props, "osgi", def);
            this.setProperty(props, "org.osgi.framework.storage", def);
            this.setProperty(props, "onFirstInit", def);
            this.setProperty(props, "org.osgi.framework.system.packages", def);
            this.setProperty(props, "org.osgi.framework.system.packages.extra", def);
            this.setProperty(props, "org.osgi.framework.vendor", def);
            this.setProperty(props, "org.osgi.framework.version", def);
            this.setProperty(props, "org.osgi.framework.windowsystem", def);
            this.setProperty(props, "org.osgi.supports.bootclasspath.extension", def);
            this.setProperty(props, "org.osgi.supports.framework.extension", def);
            this.setProperty(props, "org.osgi.supports.framework.fragment", def);
            this.setProperty(props, "org.osgi.supports.framework.requirebundle", def);
            if (this.dumpToFile) {
                PrintStream ps = new PrintStream(new File(this.bundleContext.getProperty("karaf.data"), "dump-properties-" + System.currentTimeMillis() + ".properties"));
                ps.println("#Dump of the System and OSGi properties with the command system:property");
                ps.println("#Dump executed at " + new SimpleDateFormat().format(new Date()));
                this.printOrderedProperties(props, ps);
                ps.flush();
                ps.close();
            } else {
                this.printOrderedProperties(props, System.out);
            }
            return null;
        }
        if (this.value != null) {
            this.systemService.setSystemProperty(this.key, this.value, this.persistent);
        } else {
            System.out.println(System.getProperty(this.key));
        }
        return null;
    }

    private void printOrderedProperties(Properties props, PrintStream out) {
        Set<Object> keys = props.keySet();
        Vector<String> order = new Vector<String>(keys.size());
        for (Object str : keys) {
            order.add((String)str);
        }
        Collections.sort(order);
        for (String key : order) {
            out.println(key + "=" + props.getProperty(key));
        }
    }

    private void setProperty(Properties props, String key, String def) {
        String val = this.bundleContext.getProperty(key);
        if (val == null && def != null) {
            props.setProperty(key, def);
        } else if (val != null) {
            props.setProperty(key, val);
        }
    }
}

