/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.shell.impl.console;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.karaf.shell.api.console.Terminal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Branding {
    static final Logger LOGGER = LoggerFactory.getLogger(Branding.class);

    private Branding() {
    }

    public static Properties loadBrandingProperties() {
        Properties props = new Properties();
        Branding.loadProps(props, "org/apache/karaf/shell/console/branding.properties");
        Branding.loadProps(props, "org/apache/karaf/branding/branding.properties");
        return props;
    }

    public static Properties loadBrandingProperties(Terminal terminal) {
        Properties props = new Properties();
        if (terminal != null && terminal.getClass().getName().endsWith("SshTerminal")) {
            Branding.loadProps(props, "org/apache/karaf/shell/console/branding-ssh.properties");
            Branding.loadProps(props, "org/apache/karaf/branding/branding.properties");
            return Branding.loadEtcBrandingFile("branding-ssh.properties", props);
        }
        Branding.loadProps(props, "org/apache/karaf/shell/console/branding.properties");
        Branding.loadProps(props, "org/apache/karaf/branding/branding.properties");
        return Branding.loadEtcBrandingFile("branding.properties", props);
    }

    private static Properties loadEtcBrandingFile(String fileName, Properties props) {
        File etcBranding = new File(System.getProperty("karaf.etc"), fileName);
        if (etcBranding.exists()) {
            FileInputStream etcBrandingIs = null;
            try {
                etcBrandingIs = new FileInputStream(etcBranding);
            }
            catch (FileNotFoundException e) {
                LOGGER.trace("Could not load branding.", (Throwable)e);
            }
            Branding.loadProps(props, etcBrandingIs);
        }
        return props;
    }

    protected static void loadProps(Properties props, String resource) {
        InputStream is = Branding.class.getClassLoader().getResourceAsStream(resource);
        Branding.loadProps(props, is);
    }

    protected static void loadProps(Properties props, InputStream is) {
        try {
            if (is != null) {
                props.load(is);
            }
        }
        catch (IOException iOException) {
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

