/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.shell.impl.console;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import jline.Terminal2;
import jline.TerminalSupport;
import jline.internal.InfoCmp;
import org.apache.karaf.shell.api.console.Terminal;

public class KarafTerminal
extends TerminalSupport
implements Terminal2 {
    private final Terminal terminal;
    private Set<String> bools = new HashSet<String>();
    private Map<String, Integer> ints = new HashMap<String, Integer>();
    private Map<String, String> strings = new HashMap<String, String>();

    public KarafTerminal(Terminal terminal) {
        super(true);
        String caps;
        this.terminal = terminal;
        String type = terminal.getType();
        if (type == null && terminal.isAnsiSupported()) {
            type = "ansi";
        }
        try {
            caps = InfoCmp.getInfoCmp((String)type);
        }
        catch (Exception e) {
            caps = InfoCmp.getAnsiCaps();
        }
        try {
            InfoCmp.parseInfoCmp((String)caps, this.bools, this.ints, this.strings);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public synchronized boolean isAnsiSupported() {
        return this.terminal.isAnsiSupported();
    }

    public int getWidth() {
        return this.terminal.getWidth();
    }

    public int getHeight() {
        return this.terminal.getHeight();
    }

    public synchronized boolean isEchoEnabled() {
        return false;
    }

    public synchronized void setEchoEnabled(boolean enabled) {
    }

    public boolean getBooleanCapability(String capability) {
        return this.bools.contains(capability);
    }

    public Integer getNumericCapability(String capability) {
        return this.ints.get(capability);
    }

    public String getStringCapability(String capability) {
        return this.strings.get(capability);
    }
}

