/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.shell.support.terminal;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import org.apache.karaf.shell.api.console.Signal;
import org.apache.karaf.shell.api.console.SignalListener;

public class SignalSupport {
    private final Map<Signal, Set<SignalListener>> listeners = new ConcurrentHashMap<Signal, Set<SignalListener>>(3);

    public void addSignalListener(SignalListener listener, Signal ... signals) {
        if (signals == null) {
            throw new IllegalArgumentException("signals may not be null");
        }
        if (listener == null) {
            throw new IllegalArgumentException("listener may not be null");
        }
        for (Signal s : signals) {
            this.getSignalListeners(s, true).add(listener);
        }
    }

    public void addSignalListener(SignalListener listener) {
        this.addSignalListener(listener, EnumSet.allOf(Signal.class));
    }

    public void addSignalListener(SignalListener listener, EnumSet<Signal> signals) {
        if (signals == null) {
            throw new IllegalArgumentException("signals may not be null");
        }
        this.addSignalListener(listener, signals.toArray(new Signal[signals.size()]));
    }

    public void removeSignalListener(SignalListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("listener may not be null");
        }
        for (Signal s : EnumSet.allOf(Signal.class)) {
            Set<SignalListener> ls = this.getSignalListeners(s, false);
            if (ls == null) continue;
            ls.remove(listener);
        }
    }

    public void signal(Signal signal) {
        Set<SignalListener> ls = this.getSignalListeners(signal, false);
        if (ls != null) {
            for (SignalListener l : ls) {
                l.signal(signal);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Set<SignalListener> getSignalListeners(Signal signal, boolean create) {
        Set<SignalListener> ls = this.listeners.get((Object)signal);
        if (ls == null && create) {
            Map<Signal, Set<SignalListener>> map = this.listeners;
            synchronized (map) {
                ls = this.listeners.get((Object)signal);
                if (ls == null) {
                    ls = new CopyOnWriteArraySet<SignalListener>();
                    this.listeners.put(signal, ls);
                }
            }
        }
        return ls;
    }
}

