/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway;

import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.apache.knox.gateway.GatewayResources;
import org.apache.knox.gateway.i18n.resources.ResourcesFactory;

public class GatewayCommandLine {
    public static final int LINE_WIDTH = 80;
    public static final String COMMAND_NAME = "knox";
    public static final String HELP_LONG = "help";
    public static final String HELP_SHORT = "h";
    public static final String VERSION_LONG = "version";
    public static final String VERSION_SHORT = "v";
    public static final String PERSIST_LONG = "persist-master";
    public static final String PERSIST_SHORT = "pm";
    public static final String NOSTART_LONG = "nostart";
    public static final String NOSTART_SHORT = "ns";
    public static final String REDEPLOY_LONG = "redeploy";
    public static final String REDEPLOY_SHORT = "rd";
    private static GatewayResources res = (GatewayResources)ResourcesFactory.get(GatewayResources.class);

    public static CommandLine parse(String[] args) throws ParseException {
        PosixParser parser = new PosixParser();
        CommandLine commandLine = parser.parse(GatewayCommandLine.createCommandLine(), args);
        return commandLine;
    }

    public static void printUsage() {
        PrintWriter printer = new PrintWriter((Writer)new OutputStreamWriter((OutputStream)System.err, StandardCharsets.UTF_8), true);
        new HelpFormatter().printUsage(printer, 80, COMMAND_NAME, GatewayCommandLine.createCommandLine());
        printer.flush();
    }

    public static void printHelp() {
        PrintWriter printer = new PrintWriter((Writer)new OutputStreamWriter((OutputStream)System.err, StandardCharsets.UTF_8), true);
        new HelpFormatter().printHelp(printer, 80, COMMAND_NAME, null, GatewayCommandLine.createCommandLine(), 1, 3, null);
        printer.flush();
    }

    private static Options createCommandLine() {
        Options options = new Options();
        options.addOption(HELP_SHORT, HELP_LONG, false, res.helpMessage());
        options.addOption(VERSION_SHORT, VERSION_LONG, false, res.versionHelpMessage());
        Option redeploy = new Option(REDEPLOY_SHORT, REDEPLOY_LONG, true, res.redeployHelpMessage());
        redeploy.setOptionalArg(true);
        options.addOption(redeploy);
        options.addOption(PERSIST_SHORT, PERSIST_LONG, false, res.persistMasterHelpMessage());
        options.addOption(NOSTART_SHORT, NOSTART_LONG, false, res.nostartHelpMessage());
        return options;
    }
}

