/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.trace;

import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.knox.gateway.audit.api.CorrelationContext;
import org.apache.knox.gateway.audit.api.CorrelationService;
import org.apache.knox.gateway.audit.api.CorrelationServiceFactory;

public class TraceUtil {
    private static CorrelationService cs = CorrelationServiceFactory.getCorrelationService();

    static final void appendCorrelationContext(StringBuilder sb) {
        CorrelationContext cc = cs.getContext();
        if (cc == null) {
            sb.append("||");
        } else {
            TraceUtil.append(sb, cc.getRootRequestId());
            sb.append("|");
            TraceUtil.append(sb, cc.getParentRequestId());
            sb.append("|");
            TraceUtil.append(sb, cc.getRequestId());
        }
    }

    private static final void append(StringBuilder sb, String s) {
        if (s != null) {
            sb.append(s);
        }
    }

    static final Set<Integer> parseIntegerSet(String str) {
        HashSet<Integer> set = new HashSet<Integer>();
        if (str != null && !str.trim().isEmpty()) {
            StringTokenizer parser = new StringTokenizer(str.trim(), ",", false);
            while (parser.hasMoreTokens()) {
                TraceUtil.addParsedIntegerToSet(set, parser.nextToken());
            }
        }
        return set;
    }

    private static final void addParsedIntegerToSet(Set<Integer> set, String str) {
        if (str != null && !str.trim().isEmpty()) {
            try {
                set.add(Integer.valueOf(str.trim()));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }
}

