/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.core.matching;

import java.util.ArrayList;
import java.util.Map;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.matching.Matcher;
import org.pac4j.core.matching.MatchingChecker;
import org.pac4j.core.util.CommonHelper;

public class RequireAllMatchersChecker
implements MatchingChecker {
    @Override
    public boolean matches(WebContext context, String matcherNames, Map<String, Matcher> matchersMap) {
        if (CommonHelper.isNotBlank(matcherNames)) {
            ArrayList<Matcher> matchers = new ArrayList<Matcher>();
            CommonHelper.assertNotNull("matchersMap", matchersMap);
            for (String name : matcherNames.split(",")) {
                Matcher result = null;
                for (Map.Entry<String, Matcher> entry : matchersMap.entrySet()) {
                    if (!CommonHelper.areEqualsIgnoreCaseAndTrim(entry.getKey(), name)) continue;
                    result = entry.getValue();
                    break;
                }
                CommonHelper.assertNotNull("matchersMap['" + name + "']", result);
                matchers.add(result);
            }
            if (!matchers.isEmpty()) {
                for (Matcher matcher : matchers) {
                    if (matcher.matches(context)) continue;
                    return false;
                }
            }
        }
        return true;
    }
}

