(function() {
  'use strict';
  var escope, esprima, expect;

  expect = require('chai').expect;

  escope = require('..');

  esprima = require('esprima');

  describe('optimistic', function() {
    it('direct call to eval', function() {
      var ast, scopes;
      ast = esprima.parse("function outer() {\n    eval(str);\n    var i = 20;\n    function inner() {\n        i;\n    }\n}");
      scopes = escope.analyze(ast, {
        optimistic: true
      }).scopes;
      return expect(scopes.map(function(scope) {
        return scope.variables.map(function(variable) {
          return variable.name;
        });
      })).to.be.eql([['outer'], ['arguments', 'i', 'inner'], ['arguments']]);
    });
    return it('with statement', function() {
      var ast, scopes;
      ast = esprima.parse("function outer() {\n    eval(str);\n    var i = 20;\n    with (obj) {\n        i;\n    }\n}");
      scopes = escope.analyze(ast, {
        optimistic: true
      }).scopes;
      return expect(scopes.map(function(scope) {
        return scope.variables.map(function(variable) {
          return variable.name;
        });
      })).to.be.eql([['outer'], ['arguments', 'i'], []]);
    });
  });

}).call(this);

//# sourceMappingURL=data:application/json;base64,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