/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.services.token.impl;

import org.apache.knox.gateway.i18n.messages.Message;
import org.apache.knox.gateway.i18n.messages.MessageLevel;
import org.apache.knox.gateway.i18n.messages.Messages;
import org.apache.knox.gateway.i18n.messages.StackTrace;

@Messages(logger="org.apache.knox.gateway.services.token.state")
public interface TokenStateServiceMessages {
    @Message(level=MessageLevel.DEBUG, text="Added token {0}, expiration {1}")
    public void addedToken(String var1, String var2);

    @Message(level=MessageLevel.DEBUG, text="Renewed token {0}, expiration {1}")
    public void renewedToken(String var1, String var2);

    @Message(level=MessageLevel.DEBUG, text="Revoked token {0}")
    public void revokedToken(String var1);

    @Message(level=MessageLevel.DEBUG, text="Removed state for tokens {0}")
    public void removedTokenState(String var1);

    @Message(level=MessageLevel.ERROR, text="Unknown token {0}")
    public void unknownToken(String var1);

    @Message(level=MessageLevel.ERROR, text="The renewal limit for the token ({0}) has been exceeded.")
    public void renewalLimitExceeded(String var1);

    @Message(level=MessageLevel.ERROR, text="Failed to save state for token {0} : {1}")
    public void failedToSaveTokenState(String var1, @StackTrace(level=MessageLevel.DEBUG) Exception var2);

    @Message(level=MessageLevel.ERROR, text="Error accessing token state : {0}")
    public void errorAccessingTokenState(@StackTrace(level=MessageLevel.DEBUG) Exception var1);

    @Message(level=MessageLevel.ERROR, text="Error accessing state for token {0} : {1}")
    public void errorAccessingTokenState(String var1, @StackTrace(level=MessageLevel.DEBUG) Exception var2);

    @Message(level=MessageLevel.INFO, text="Referencing the expiration in the token ({0}) because no state could not be found: {1}")
    public void permissiveTokenHandling(String var1, String var2);

    @Message(level=MessageLevel.ERROR, text="Failed to update expiration for token {0} : {1}")
    public void failedToUpdateTokenExpiration(String var1, @StackTrace(level=MessageLevel.DEBUG) Exception var2);

    @Message(level=MessageLevel.ERROR, text="Failed to create token state aliases : {0}")
    public void failedToCreateTokenStateAliases(@StackTrace(level=MessageLevel.DEBUG) Exception var1);

    @Message(level=MessageLevel.ERROR, text="Failed to remove state for token {0} : {1}")
    public void failedToRemoveTokenStateAliases(String var1, @StackTrace(level=MessageLevel.DEBUG) Exception var2);

    @Message(level=MessageLevel.ERROR, text="Failed to remove token state aliases : {0}")
    public void failedToRemoveTokenStateAliases(@StackTrace(level=MessageLevel.DEBUG) Exception var1);

    @Message(level=MessageLevel.DEBUG, text="Skipping expired token eviction")
    public void skipEviction();

    @Message(level=MessageLevel.ERROR, text="Failed to evict expired token {0} : {1}")
    public void failedExpiredTokenEviction(String var1, @StackTrace(level=MessageLevel.DEBUG) Exception var2);

    @Message(level=MessageLevel.ERROR, text="Failed to evict expired tokens : {0}")
    public void failedExpiredTokenEviction(@StackTrace(level=MessageLevel.DEBUG) Exception var1);

    @Message(level=MessageLevel.INFO, text="Evicting expired token {0}")
    public void evictToken(String var1);

    @Message(level=MessageLevel.ERROR, text="Error occurred evicting token {0}")
    public void errorEvictingTokens(@StackTrace(level=MessageLevel.DEBUG) Exception var1);

    @Message(level=MessageLevel.INFO, text="Running token state alias persister task in every {0} {1}")
    public void runningTokenStateAliasePersisterTask(long var1, String var3);

    @Message(level=MessageLevel.INFO, text="Canceling token state alias persister task")
    public void cancelingTokenStateAliasePersisterTask();

    @Message(level=MessageLevel.ERROR, text="An error occurred while running token state alias persister task: {0}")
    public void errorRunningTokenStateAliasePersisterTask(@StackTrace(level=MessageLevel.DEBUG) Throwable var1);

    @Message(level=MessageLevel.INFO, text="Creating token state aliases")
    public void creatingTokenStateAliases();

    @Message(level=MessageLevel.DEBUG, text="Creating token state aliases for {0}")
    public void creatingTokenStateAliases(String var1);

    @Message(level=MessageLevel.INFO, text="Created token state aliases for {0}")
    public void createdTokenStateAliases(String var1);

    @Message(level=MessageLevel.INFO, text="Removing token state aliases")
    public void removingTokenStateAliases();

    @Message(level=MessageLevel.DEBUG, text="Removing token state aliases for {0}")
    public void removingTokenStateAliases(String var1);

    @Message(level=MessageLevel.INFO, text="Removed token state aliases for {0}")
    public void removedTokenStateAliases(String var1);

    @Message(level=MessageLevel.DEBUG, text="Loading peristed token state journal entries")
    public void loadingPersistedJournalEntries();

    @Message(level=MessageLevel.DEBUG, text="Loaded peristed token state journal entry for {0}")
    public void loadedPersistedJournalEntry(String var1);

    @Message(level=MessageLevel.ERROR, text="The peristed token state journal entry {0} is empty")
    public void emptyJournalEntry(String var1);

    @Message(level=MessageLevel.DEBUG, text="Added token state journal entry for {0}")
    public void addedJournalEntry(String var1);

    @Message(level=MessageLevel.DEBUG, text="Removed token state journal entry for {0}")
    public void removedJournalEntry(String var1);

    @Message(level=MessageLevel.INFO, text="Token state journal entry not found for {0}")
    public void journalEntryNotFound(String var1);

    @Message(level=MessageLevel.DEBUG, text="Persisting token state journal entry as {0}")
    public void persistingJournalEntry(String var1);

    @Message(level=MessageLevel.ERROR, text="Failed to load persisted token state journal entry for {0} : {1}")
    public void failedToLoadJournalEntry(String var1, @StackTrace(level=MessageLevel.DEBUG) Exception var2);

    @Message(level=MessageLevel.ERROR, text="Failed to load persisted token state journal entry : {0}")
    public void failedToLoadJournalEntry(@StackTrace(level=MessageLevel.DEBUG) Exception var1);

    @Message(level=MessageLevel.ERROR, text="Failed to persisting token state journal entry for {0} : {1}")
    public void failedToPersistJournalEntry(String var1, @StackTrace(level=MessageLevel.DEBUG) Exception var2);

    @Message(level=MessageLevel.ERROR, text="Failed to add a token state journal entry for {0} : {1}")
    public void failedToAddJournalEntry(String var1, @StackTrace(level=MessageLevel.DEBUG) Exception var2);

    @Message(level=MessageLevel.ERROR, text="Failed to remove the token state journal entry for {0} : {1}")
    public void failedToRemoveJournalEntry(String var1, @StackTrace(level=MessageLevel.DEBUG) Exception var2);

    @Message(level=MessageLevel.ERROR, text="Failed to remove the token state journal entries : {0}")
    public void failedToRemoveJournalEntries(@StackTrace(level=MessageLevel.DEBUG) Exception var1);

    @Message(level=MessageLevel.INFO, text="Loading token aliases from persistence store on startup...")
    public void loadingTokenAliasesFromPersistenceStore();

    @Message(level=MessageLevel.INFO, text="Processing {0} aliases from persistence store on startup...")
    public void processingAliases(int var1);

    @Message(level=MessageLevel.INFO, text="Loaded {0} token aliases from persistence store in {1} milliseconds")
    public void loadedTokenAliasesFromPersistenceStore(int var1, long var2);

    @Message(level=MessageLevel.ERROR, text="Error while loading token aliases from persistence store on startup: {0}")
    public void errorWhileLoadingTokenAliasesFromPersistenceStore(String var1, @StackTrace(level=MessageLevel.DEBUG) Throwable var2);

    @Message(level=MessageLevel.ERROR, text="Error while processing token alias {0} : {1}")
    public void errorWhileProcessingTokenAlias(String var1, String var2, @StackTrace(level=MessageLevel.DEBUG) Throwable var3);

    @Message(level=MessageLevel.DEBUG, text="Invalid alias value for {0}; it has very likely been evicted in the meantime")
    public void invalidAliasValue(String var1);

    @Message(level=MessageLevel.INFO, text="Trying to fetch value for {0} from Zookeeper...")
    public void retryZkFetchAlias(String var1);

    @Message(level=MessageLevel.ERROR, text="Error while fetching value for {0} from Zookeeper: {1}")
    public void failedRetryZkFetchAlias(String var1, String var2, @StackTrace(level=MessageLevel.DEBUG) Exception var3);

    @Message(level=MessageLevel.INFO, text="Processed alias {0} on receiving signal from Zookeeper ")
    public void onRemoteTokenStateChanged(String var1);

    @Message(level=MessageLevel.INFO, text="Removed related token alias {0} on receiving signal from Zookeeper ")
    public void onRemoteTokenStateRemoval(String var1);

    @Message(level=MessageLevel.DEBUG, text="Token {0} has been saved in the database")
    public void savedTokenInDatabase(String var1);

    @Message(level=MessageLevel.ERROR, text="Failed to save token {0} in the database")
    public void failedToSaveTokenInDatabase(String var1);

    @Message(level=MessageLevel.ERROR, text="An error occurred while saving token {0} in the database : {1}")
    public void errorSavingTokenInDatabase(String var1, String var2, @StackTrace(level=MessageLevel.DEBUG) Exception var3);

    @Message(level=MessageLevel.DEBUG, text="Token {0} has been removed from the database")
    public void removedTokenFromDatabase(String var1);

    @Message(level=MessageLevel.ERROR, text="An error occurred while removing token {0} from the database : {1}")
    public void errorRemovingTokenFromDatabase(String var1, String var2, @StackTrace(level=MessageLevel.DEBUG) Exception var3);

    @Message(level=MessageLevel.INFO, text="Removing {0} expired token(s) from the database: {1}")
    public void removingExpiredTokensFromDatabase(int var1, String var2);

    @Message(level=MessageLevel.DEBUG, text="{0} expired tokens have been removed from the database")
    public void removedTokensFromDatabase(int var1);

    @Message(level=MessageLevel.ERROR, text="An error occurred while removing expired tokens from the database : {0}")
    public void errorRemovingTokensFromDatabase(String var1, @StackTrace(level=MessageLevel.DEBUG) Exception var2);

    @Message(level=MessageLevel.DEBUG, text="Fetched issue time for {0} from the database : {1}")
    public void fetchedIssueTimeFromDatabase(String var1, long var2);

    @Message(level=MessageLevel.ERROR, text="An error occurred while fetching issue time for {0} from the database : {1}")
    public void errorFetchingIssueTimeFromDatabase(String var1, String var2, @StackTrace(level=MessageLevel.DEBUG) Exception var3);

    @Message(level=MessageLevel.DEBUG, text="Fetched expiration for {0} from the database : {1}")
    public void fetchedExpirationFromDatabase(String var1, long var2);

    @Message(level=MessageLevel.ERROR, text="An error occurred while fetching expiration for {0} from the database : {1}")
    public void errorFetchingExpirationFromDatabase(String var1, String var2, @StackTrace(level=MessageLevel.DEBUG) Exception var3);

    @Message(level=MessageLevel.DEBUG, text="Updated expiration for {0} in the database to {1}")
    public void updatedExpirationInDatabase(String var1, long var2);

    @Message(level=MessageLevel.DEBUG, text="Failed to updated expiration for {0} in the database to {1}")
    public void failedToUpdateExpirationInDatabase(String var1, long var2);

    @Message(level=MessageLevel.ERROR, text="An error occurred while updating expiration for {0} in the database : {1}")
    public void errorUpdatingExpirationInDatabase(String var1, String var2, @StackTrace(level=MessageLevel.DEBUG) Exception var3);

    @Message(level=MessageLevel.DEBUG, text="Fetched max lifetime for {0} from the database : {1}")
    public void fetchedMaxLifetimeFromDatabase(String var1, long var2);

    @Message(level=MessageLevel.ERROR, text="An error occurred while fetching max lifetime for {0} from the database : {1}")
    public void errorFetchingMaxLifetimeFromDatabase(String var1, String var2, @StackTrace(level=MessageLevel.DEBUG) Exception var3);

    @Message(level=MessageLevel.DEBUG, text="Updated metadata for {0} in the database")
    public void updatedMetadataInDatabase(String var1);

    @Message(level=MessageLevel.DEBUG, text="Failed to save/update metadata for {0} in the database")
    public void failedToUpdateMetadataInDatabase(String var1);

    @Message(level=MessageLevel.ERROR, text="An error occurred while updating metadata for {0} in the database : {1}")
    public void errorUpdatingMetadataInDatabase(String var1, String var2, @StackTrace(level=MessageLevel.DEBUG) Exception var3);

    @Message(level=MessageLevel.DEBUG, text="Fetched metadata for {0} from the database")
    public void fetchedMetadataFromDatabase(String var1);

    @Message(level=MessageLevel.ERROR, text="An error occurred while fetching metadata for {0} from the database : {1}")
    public void errorFetchingMetadataFromDatabase(String var1, String var2, @StackTrace(level=MessageLevel.DEBUG) Exception var3);

    @Message(level=MessageLevel.ERROR, text="An error occurred while fetching tokens for user {0} from the database : {1}")
    public void errorFetchingTokensForUserFromDatabase(String var1, String var2, @StackTrace(level=MessageLevel.DEBUG) Exception var3);
}

