/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.shell.knox.token;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.concurrent.Callable;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.StringEntity;
import org.apache.knox.gateway.shell.AbstractRequest;
import org.apache.knox.gateway.shell.ErrorResponse;
import org.apache.knox.gateway.shell.KnoxSession;
import org.apache.knox.gateway.shell.KnoxShellException;
import org.apache.knox.gateway.shell.knox.token.Token;
import org.apache.knox.gateway.shell.knox.token.TokenLifecycleResponse;

public abstract class AbstractTokenLifecycleRequest
extends AbstractRequest<TokenLifecycleResponse> {
    private URI requestURI;
    private HttpPost httpPostRequest;
    private String token;

    AbstractTokenLifecycleRequest(KnoxSession session, String token) {
        this(session, token, null);
    }

    AbstractTokenLifecycleRequest(KnoxSession session, String token, String doAsUser) {
        super(session, doAsUser);
        this.token = token;
        try {
            URIBuilder uri = this.uri(Token.SERVICE_PATH, "/", this.getOperation());
            this.requestURI = uri.build();
        }
        catch (URISyntaxException e) {
            throw new KnoxShellException(e);
        }
    }

    protected abstract String getOperation();

    public URI getRequestURI() {
        return this.requestURI;
    }

    public HttpPost getRequest() {
        return this.httpPostRequest;
    }

    public String getToken() {
        return this.token;
    }

    @Override
    protected Callable<TokenLifecycleResponse> callable() {
        return () -> {
            this.httpPostRequest = new HttpPost(this.requestURI);
            this.httpPostRequest.setEntity((HttpEntity)new StringEntity(this.token));
            try {
                return new TokenLifecycleResponse((HttpResponse)this.execute((HttpRequest)this.httpPostRequest));
            }
            catch (ErrorResponse e) {
                return new TokenLifecycleResponse(e.getResponse());
            }
        };
    }
}

