/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.topology.discovery.cm.monitor;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.knox.gateway.topology.discovery.ServiceDiscoveryConfig;
import org.apache.knox.gateway.topology.discovery.cm.monitor.ServiceConfigurationModel;

class ClusterConfigurationCache {
    private final Map<String, Map<String, ServiceDiscoveryConfig>> clusterMonitorConfigurations = new ConcurrentHashMap<String, Map<String, ServiceDiscoveryConfig>>();
    private final Map<String, Map<String, Map<String, ServiceConfigurationModel>>> clusterServiceConfigurations = new ConcurrentHashMap<String, Map<String, Map<String, ServiceConfigurationModel>>>();
    private final ReadWriteLock serviceConfigurationsLock = new ReentrantReadWriteLock();
    private final ReadWriteLock clusterMonitorConfigurationsLock = new ReentrantReadWriteLock();

    ClusterConfigurationCache() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addServiceConfiguration(String address, String cluster, Map<String, ServiceConfigurationModel> configs) {
        this.serviceConfigurationsLock.writeLock().lock();
        try {
            this.clusterServiceConfigurations.computeIfAbsent(address, k -> new HashMap()).put(cluster, configs);
        }
        finally {
            this.serviceConfigurationsLock.writeLock().unlock();
        }
    }

    void addDiscoveryConfig(ServiceDiscoveryConfig config) {
        this.clusterMonitorConfigurationsLock.writeLock().lock();
        try {
            this.clusterMonitorConfigurations.computeIfAbsent(config.getAddress(), k -> new HashMap()).put(config.getCluster(), config);
        }
        finally {
            this.clusterMonitorConfigurationsLock.writeLock().unlock();
        }
    }

    void removeServiceConfiguration(String address, String clusterName) {
        this.serviceConfigurationsLock.writeLock().lock();
        try {
            this.clusterServiceConfigurations.get(address).remove(clusterName);
        }
        finally {
            this.serviceConfigurationsLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ServiceDiscoveryConfig getDiscoveryConfig(String address, String clusterName) {
        ServiceDiscoveryConfig config = null;
        this.clusterMonitorConfigurationsLock.readLock().lock();
        try {
            Map<String, ServiceDiscoveryConfig> clusterMap = this.clusterMonitorConfigurations.get(address);
            if (clusterMap != null) {
                config = clusterMap.get(clusterName);
            }
        }
        finally {
            this.clusterMonitorConfigurationsLock.readLock().unlock();
        }
        return config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Map<String, ServiceConfigurationModel> getClusterServiceConfigurations(String address, String clusterName) {
        HashMap<String, ServiceConfigurationModel> result = new HashMap<String, ServiceConfigurationModel>();
        this.serviceConfigurationsLock.readLock().lock();
        try {
            Map<String, Map<String, ServiceConfigurationModel>> clusterMap = this.clusterServiceConfigurations.get(address);
            if (clusterMap != null) {
                result.putAll(clusterMap.get(clusterName));
            }
        }
        finally {
            this.serviceConfigurationsLock.readLock().unlock();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Map<String, List<String>> getClusterNames() {
        HashMap<String, List<String>> result = new HashMap<String, List<String>>();
        this.serviceConfigurationsLock.readLock().lock();
        try {
            for (Map.Entry<String, Map<String, Map<String, ServiceConfigurationModel>>> configs : this.clusterServiceConfigurations.entrySet()) {
                result.put(configs.getKey(), new ArrayList<String>(configs.getValue().keySet()));
            }
        }
        finally {
            this.serviceConfigurationsLock.readLock().unlock();
        }
        return result;
    }
}

