/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.kylin.query.engine.exec.sparder;

import java.util.List;

import org.apache.calcite.DataContext;
import org.apache.calcite.rel.RelNode;
import org.apache.kylin.query.engine.exec.ExecuteResult;

public interface QueryEngine {

    /**
     * execute and return rows in string
     * @param dataContext
     * @param relNode
     * @return
     * @deprecated
     */
    @Deprecated
    List<List<String>> compute(DataContext dataContext, RelNode relNode);

    default ExecuteResult computeToIterable(DataContext dataContext, RelNode relNode) {
        List<List<String>> rows = compute(dataContext, relNode);
        return new ExecuteResult(rows, rows == null ? 0 : rows.size());
    }
}
