/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.jmx.gui;

import aQute.bnd.annotation.jpms.MainClass;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import javax.management.InstanceNotFoundException;
import javax.management.JMException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanServerDelegate;
import javax.management.MBeanServerNotification;
import javax.management.MalformedObjectNameException;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.NotificationFilterSupport;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import javax.swing.AbstractAction;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.apache.logging.log4j.core.jmx.LoggerContextAdminMBean;
import org.apache.logging.log4j.core.jmx.StatusLoggerAdminMBean;
import org.apache.logging.log4j.jmx.gui.Client;
import org.apache.logging.log4j.jmx.gui.ClientEditConfigPanel;

@MainClass
@SuppressFBWarnings(value={"INFORMATION_EXPOSURE_THROUGH_AN_ERROR_MESSAGE"})
public class ClientGui
extends JPanel
implements NotificationListener {
    private static final long serialVersionUID = -253621277232291174L;
    private static final int INITIAL_STRING_WRITER_SIZE = 1024;
    private final Client client;
    private final Map<ObjectName, Component> contextObjNameToTabbedPaneMap = new HashMap<ObjectName, Component>();
    private final Map<ObjectName, JTextArea> statusLogTextAreaMap = new HashMap<ObjectName, JTextArea>();
    private JTabbedPane tabbedPaneContexts;

    public ClientGui(Client client) throws IOException, JMException {
        this.client = Objects.requireNonNull(client, "client");
        this.createWidgets();
        this.populateWidgets();
        ObjectName addRemoveNotifs = MBeanServerDelegate.DELEGATE_NAME;
        NotificationFilterSupport filter = new NotificationFilterSupport();
        filter.enableType("org.apache.logging.log4j2");
        client.getConnection().addNotificationListener(addRemoveNotifs, this, null, null);
    }

    private void createWidgets() {
        this.tabbedPaneContexts = new JTabbedPane();
        this.setLayout(new BorderLayout());
        this.add((Component)this.tabbedPaneContexts, "Center");
    }

    private void populateWidgets() throws IOException, JMException {
        for (LoggerContextAdminMBean ctx : this.client.getLoggerContextAdmins()) {
            this.addWidgetForLoggerContext(ctx);
        }
    }

    private void addWidgetForLoggerContext(LoggerContextAdminMBean ctx) throws MalformedObjectNameException, IOException, InstanceNotFoundException {
        JTabbedPane contextTabs = new JTabbedPane();
        this.contextObjNameToTabbedPaneMap.put(ctx.getObjectName(), contextTabs);
        this.tabbedPaneContexts.addTab("LoggerContext: " + ctx.getName(), contextTabs);
        String contextName = ctx.getName();
        StatusLoggerAdminMBean status = this.client.getStatusLoggerAdmin(contextName);
        if (status != null) {
            String[] messages;
            JTextArea text = this.createTextArea();
            for (String message : messages = status.getStatusDataHistory()) {
                text.append(message + '\n');
            }
            this.statusLogTextAreaMap.put(ctx.getObjectName(), text);
            this.registerListeners(status);
            JScrollPane scroll = this.scroll(text);
            contextTabs.addTab("StatusLogger", scroll);
        }
        ClientEditConfigPanel editor = new ClientEditConfigPanel(ctx);
        contextTabs.addTab("Configuration", editor);
    }

    private void removeWidgetForLoggerContext(ObjectName loggerContextObjName) throws JMException, IOException {
        Component tab = this.contextObjNameToTabbedPaneMap.get(loggerContextObjName);
        if (tab != null) {
            this.tabbedPaneContexts.remove(tab);
        }
        this.statusLogTextAreaMap.remove(loggerContextObjName);
        ObjectName objName = this.client.getStatusLoggerObjectName(loggerContextObjName);
        try {
            this.client.getConnection().removeNotificationListener(objName, this);
        }
        catch (ListenerNotFoundException listenerNotFoundException) {
            // empty catch block
        }
    }

    private JTextArea createTextArea() {
        JTextArea result = new JTextArea();
        result.setEditable(false);
        result.setBackground(this.getBackground());
        result.setForeground(Color.black);
        result.setFont(new Font("Monospaced", 0, result.getFont().getSize()));
        result.setWrapStyleWord(true);
        return result;
    }

    private JScrollPane scroll(final JTextArea text) {
        final JToggleButton toggleButton = new JToggleButton();
        toggleButton.setAction(new AbstractAction(){
            private static final long serialVersionUID = -4214143754637722322L;

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean wrap = toggleButton.isSelected();
                text.setLineWrap(wrap);
            }
        });
        toggleButton.setToolTipText("Toggle line wrapping");
        JScrollPane scrollStatusLog = new JScrollPane(text, 22, 32);
        scrollStatusLog.setCorner("LOWER_RIGHT_CORNER", toggleButton);
        return scrollStatusLog;
    }

    private void registerListeners(StatusLoggerAdminMBean status) throws InstanceNotFoundException, MalformedObjectNameException, IOException {
        NotificationFilterSupport filter = new NotificationFilterSupport();
        filter.enableType("com.apache.logging.log4j.core.jmx.statuslogger.message");
        ObjectName objName = status.getObjectName();
        this.client.getConnection().addNotificationListener(objName, this, (NotificationFilter)filter, (Object)status.getContextName());
    }

    @Override
    public void handleNotification(Notification notif, Object paramObject) {
        SwingUtilities.invokeLater(() -> this.handleNotificationInAwtEventThread(notif, paramObject));
    }

    private void handleNotificationInAwtEventThread(Notification notif, Object paramObject) {
        if ("com.apache.logging.log4j.core.jmx.statuslogger.message".equals(notif.getType())) {
            if (!(paramObject instanceof ObjectName)) {
                this.handle("Invalid notification object type", new ClassCastException(paramObject.getClass().getName()));
                return;
            }
            ObjectName param = (ObjectName)paramObject;
            JTextArea text = this.statusLogTextAreaMap.get(param);
            if (text != null) {
                text.append(notif.getMessage() + '\n');
            }
            return;
        }
        if (notif instanceof MBeanServerNotification) {
            MBeanServerNotification mbsn = (MBeanServerNotification)notif;
            ObjectName mbeanName = mbsn.getMBeanName();
            if ("JMX.mbean.registered".equals(notif.getType())) {
                this.onMBeanRegistered(mbeanName);
            } else if ("JMX.mbean.unregistered".equals(notif.getType())) {
                this.onMBeanUnregistered(mbeanName);
            }
        }
    }

    private void onMBeanRegistered(ObjectName mbeanName) {
        if (this.client.isLoggerContext(mbeanName)) {
            try {
                LoggerContextAdminMBean ctx = this.client.getLoggerContextAdmin(mbeanName);
                this.addWidgetForLoggerContext(ctx);
            }
            catch (Exception ex) {
                this.handle("Could not add tab for new MBean " + mbeanName, ex);
            }
        }
    }

    private void onMBeanUnregistered(ObjectName mbeanName) {
        if (this.client.isLoggerContext(mbeanName)) {
            try {
                this.removeWidgetForLoggerContext(mbeanName);
            }
            catch (Exception ex) {
                this.handle("Could not remove tab for " + mbeanName, ex);
            }
        }
    }

    private void handle(String msg, Exception ex) {
        System.err.println(msg);
        ex.printStackTrace();
        StringWriter sw = new StringWriter(1024);
        ex.printStackTrace(new PrintWriter(sw));
        JOptionPane.showMessageDialog(this, sw.toString(), msg, 0);
    }

    public static void main(String[] args) throws Exception {
        if (args.length < 1) {
            ClientGui.usage();
            return;
        }
        String serviceUrl = args[0];
        if (!serviceUrl.startsWith("service:jmx")) {
            serviceUrl = "service:jmx:rmi:///jndi/rmi://" + args[0] + "/jmxrmi";
        }
        JMXServiceURL url = new JMXServiceURL(serviceUrl);
        Properties props = System.getProperties();
        HashMap<String, String> paramMap = new HashMap<String, String>(props.size());
        for (String key : props.stringPropertyNames()) {
            paramMap.put(key, props.getProperty(key));
        }
        JMXConnector connector = JMXConnectorFactory.connect(url, paramMap);
        Client client = new Client(connector);
        String title = "Log4j JMX Client - " + url;
        SwingUtilities.invokeLater(() -> {
            ClientGui.installLookAndFeel();
            try {
                ClientGui gui = new ClientGui(client);
                JFrame frame = new JFrame(title);
                frame.setDefaultCloseOperation(3);
                frame.getContentPane().add((Component)gui, "Center");
                frame.pack();
                frame.setVisible(true);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                StringWriter sr = new StringWriter();
                ex.printStackTrace(new PrintWriter(sr));
                JOptionPane.showMessageDialog(null, sr.toString(), "Error", 0);
            }
        });
    }

    private static void usage() {
        String me = ClientGui.class.getName();
        System.err.println("Usage: java " + me + " <host>:<port>");
        System.err.println("   or: java " + me + " service:jmx:rmi:///jndi/rmi://<host>:<port>/jmxrmi");
        String longAdr = " service:jmx:rmi://<host>:<port>/jndi/rmi://<host>:<port>/jmxrmi";
        System.err.println("   or: java " + me + " service:jmx:rmi://<host>:<port>/jndi/rmi://<host>:<port>/jmxrmi");
    }

    private static void installLookAndFeel() {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                return;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

