/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.randomizedtesting.rules;

import com.carrotsearch.randomizedtesting.rules.SystemPropertiesRestoreRule;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.MultipleFailureException;
import org.junit.runners.model.Statement;

public class SystemPropertiesInvariantRule
implements TestRule {
    private final HashSet<String> ignoredProperties;

    public SystemPropertiesInvariantRule() {
        this(Collections.emptySet());
    }

    public SystemPropertiesInvariantRule(String ... ignoredProperties) {
        this.ignoredProperties = new HashSet<String>(Arrays.asList(ignoredProperties));
    }

    public SystemPropertiesInvariantRule(Set<String> ignoredProperties) {
        this.ignoredProperties = new HashSet<String>(ignoredProperties);
    }

    public Statement apply(final Statement s, Description d) {
        return new Statement(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void evaluate() throws Throwable {
                TreeMap<String, String> before = SystemPropertiesRestoreRule.systemPropertiesAsMap();
                ArrayList<Object> errors = new ArrayList<Object>();
                try {
                    s.evaluate();
                }
                catch (Throwable t) {
                    errors.add(t);
                }
                finally {
                    TreeMap<String, String> after = SystemPropertiesRestoreRule.systemPropertiesAsMap();
                    before.keySet().removeAll(SystemPropertiesInvariantRule.this.ignoredProperties);
                    after.keySet().removeAll(SystemPropertiesInvariantRule.this.ignoredProperties);
                    if (!after.equals(before)) {
                        errors.add(new AssertionError((Object)("System properties invariant violated.\n" + this.collectErrorMessage(before, after))));
                    }
                    SystemPropertiesRestoreRule.restore(before, after, SystemPropertiesInvariantRule.this.ignoredProperties);
                }
                MultipleFailureException.assertEmpty(errors);
            }

            private StringBuilder collectErrorMessage(TreeMap<String, String> before, TreeMap<String, String> after) {
                TreeSet<String> newKeys = new TreeSet<String>(after.keySet());
                newKeys.removeAll(before.keySet());
                TreeSet<String> missingKeys = new TreeSet<String>(before.keySet());
                missingKeys.removeAll(after.keySet());
                TreeSet<String> differentKeyValues = new TreeSet<String>(before.keySet());
                differentKeyValues.retainAll(after.keySet());
                Iterator<String> i = differentKeyValues.iterator();
                while (i.hasNext()) {
                    String key = i.next();
                    String valueBefore = before.get(key);
                    String valueAfter = after.get(key);
                    if ((valueBefore != null || valueAfter != null) && !valueBefore.equals(valueAfter)) continue;
                    i.remove();
                }
                StringBuilder b = new StringBuilder();
                if (!missingKeys.isEmpty()) {
                    b.append("Missing keys:\n");
                    for (String key : missingKeys) {
                        b.append("  ").append(key).append("=").append(before.get(key)).append("\n");
                    }
                }
                if (!newKeys.isEmpty()) {
                    b.append("New keys:\n");
                    for (String key : newKeys) {
                        b.append("  ").append(key).append("=").append(after.get(key)).append("\n");
                    }
                }
                if (!differentKeyValues.isEmpty()) {
                    b.append("Different values:\n");
                    for (String key : differentKeyValues) {
                        b.append("  [old]").append(key).append("=").append(before.get(key)).append("\n");
                        b.append("  [new]").append(key).append("=").append(after.get(key)).append("\n");
                    }
                }
                return b;
            }
        };
    }
}

