/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.randomizedtesting.rules;

import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class SystemPropertiesRestoreRule
implements TestRule {
    private final Set<String> ignoredProperties;
    private final Map<String, String> setProperties;

    public SystemPropertiesRestoreRule() {
        this.ignoredProperties = Collections.emptySet();
        this.setProperties = Collections.emptyMap();
    }

    public SystemPropertiesRestoreRule(String key, String value) {
        this(Collections.singletonMap(key, value));
    }

    public SystemPropertiesRestoreRule(Map<String, String> setProperties) {
        this.setProperties = new HashMap<String, String>(setProperties);
        this.ignoredProperties = Collections.emptySet();
    }

    public SystemPropertiesRestoreRule(Set<String> ignoredProperties) {
        this.ignoredProperties = new HashSet<String>(ignoredProperties);
        this.setProperties = Collections.emptyMap();
    }

    public SystemPropertiesRestoreRule(String ... ignoredProperties) {
        this.ignoredProperties = new HashSet<String>(Arrays.asList(ignoredProperties));
        this.setProperties = Collections.emptyMap();
    }

    public Statement apply(final Statement s, Description d) {
        return new Statement(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void evaluate() throws Throwable {
                TreeMap<String, String> before = SystemPropertiesRestoreRule.systemPropertiesAsMap();
                try {
                    for (Map.Entry entry : SystemPropertiesRestoreRule.this.setProperties.entrySet()) {
                        System.setProperty((String)entry.getKey(), (String)entry.getValue());
                    }
                    s.evaluate();
                }
                finally {
                    TreeMap<String, String> after = SystemPropertiesRestoreRule.systemPropertiesAsMap();
                    if (!after.equals(before)) {
                        SystemPropertiesRestoreRule.restore(before, after, SystemPropertiesRestoreRule.this.ignoredProperties);
                    }
                }
            }
        };
    }

    private static TreeMap<String, String> cloneAsMap(Properties properties) {
        TreeMap<String, String> result = new TreeMap<String, String>();
        Enumeration<?> e = properties.propertyNames();
        while (e.hasMoreElements()) {
            Object ovalue;
            String value;
            Object key = e.nextElement();
            if (!(key instanceof String) || (value = properties.getProperty((String)key)) == null && (ovalue = properties.get(key)) != null) continue;
            result.put((String)key, value);
        }
        return result;
    }

    static void restore(TreeMap<String, String> before, TreeMap<String, String> after, Set<String> ignoredKeys) {
        after.keySet().removeAll(before.keySet());
        for (String string : after.keySet()) {
            if (ignoredKeys.contains(string)) continue;
            System.clearProperty(string);
        }
        for (Map.Entry entry : before.entrySet()) {
            String key = (String)entry.getValue();
            if (ignoredKeys.contains(key)) continue;
            if (key == null) {
                System.clearProperty((String)entry.getKey());
                continue;
            }
            System.setProperty((String)entry.getKey(), key);
        }
    }

    static TreeMap<String, String> systemPropertiesAsMap() {
        try {
            return SystemPropertiesRestoreRule.cloneAsMap(System.getProperties());
        }
        catch (SecurityException e) {
            AssertionError ae = new AssertionError((Object)"Access to System.getProperties() denied.");
            try {
                ((Throwable)((Object)ae)).initCause(e);
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw ae;
        }
    }
}

