/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.component;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.handler.component.FacetComponent;
import org.apache.solr.handler.component.ResponseBuilder;
import org.apache.solr.handler.component.ShardRequest;
import org.apache.solr.search.DocSet;
import org.apache.solr.search.facet.FacetMerger;
import org.apache.solr.search.facet.FacetRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpatialHeatmapFacets {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String RESPONSE_KEY = "facet_heatmaps";

    public static NamedList<Object> getHeatmapForField(String fieldKey, String fieldName, ResponseBuilder rb, SolrParams params, DocSet docSet) throws IOException {
        FacetRequest facetRequest = SpatialHeatmapFacets.createHeatmapRequest(fieldKey, fieldName, rb, params);
        return (NamedList)facetRequest.process(rb.req, docSet);
    }

    private static FacetRequest createHeatmapRequest(String fieldKey, String fieldName, ResponseBuilder rb, SolrParams params) {
        HashMap<String, Object> jsonFacet = new HashMap<String, Object>();
        jsonFacet.put("type", "heatmap");
        jsonFacet.put("field", fieldName);
        jsonFacet.put("geom", params.getFieldParam(fieldKey, "facet.heatmap.geom"));
        jsonFacet.put("gridLevel", params.getFieldInt(fieldKey, "facet.heatmap.gridLevel"));
        jsonFacet.put("distErrPct", params.getFieldDouble(fieldKey, "facet.heatmap.distErrPct"));
        jsonFacet.put("distErr", params.getFieldDouble(fieldKey, "facet.heatmap.distErr"));
        jsonFacet.put("maxCells", params.getFieldInt(fieldKey, "facet.heatmap.maxCells"));
        jsonFacet.put("format", params.getFieldParam(fieldKey, "facet.heatmap.format"));
        return FacetRequest.parseOneFacetReq(rb.req, jsonFacet);
    }

    public static LinkedHashMap<String, HeatmapFacet> distribParse(SolrParams params, ResponseBuilder rb) {
        LinkedHashMap<String, HeatmapFacet> heatmapFacets = new LinkedHashMap<String, HeatmapFacet>();
        String[] heatmapFields = params.getParams("facet.heatmap");
        if (heatmapFields != null) {
            for (String heatmapField : heatmapFields) {
                HeatmapFacet facet = new HeatmapFacet(rb, heatmapField);
                heatmapFacets.put(facet.getKey(), facet);
            }
        }
        return heatmapFacets;
    }

    public static void distribModifyRequest(ShardRequest sreq, LinkedHashMap<String, HeatmapFacet> heatmapFacets) {
        sreq.params.remove("facet.heatmap");
        for (HeatmapFacet facet : heatmapFacets.values()) {
            ModifiableSolrParams newLocalParams = new ModifiableSolrParams();
            if (facet.localParams != null) {
                newLocalParams.add(facet.localParams);
            }
            newLocalParams.set("facet.heatmap.format", new String[]{"png"});
            sreq.params.add("facet.heatmap", new String[]{newLocalParams.toLocalParamsString() + facet.facetOn});
        }
    }

    public static void distribHandleResponse(LinkedHashMap<String, HeatmapFacet> heatmapFacets, NamedList srsp_facet_counts) {
        NamedList facet_heatmaps = (NamedList)srsp_facet_counts.get(RESPONSE_KEY);
        if (facet_heatmaps == null) {
            return;
        }
        for (Map.Entry entry : facet_heatmaps) {
            String fieldKey = (String)entry.getKey();
            NamedList shardNamedList = (NamedList)entry.getValue();
            HeatmapFacet facet = heatmapFacets.get(fieldKey);
            if (facet == null) {
                log.error("received heatmap for field/key {} that we weren't expecting", (Object)fieldKey);
                continue;
            }
            facet.jsonFacetMerger.merge(shardNamedList, null);
        }
    }

    public static NamedList distribFinish(LinkedHashMap<String, HeatmapFacet> heatmapInfos, ResponseBuilder rb) {
        SimpleOrderedMap result = new SimpleOrderedMap();
        for (Map.Entry<String, HeatmapFacet> entry : heatmapInfos.entrySet()) {
            HeatmapFacet facet = entry.getValue();
            result.add(entry.getKey(), (Object)((NamedList)facet.jsonFacetMerger.getMergedResult()));
        }
        return result;
    }

    public static class HeatmapFacet
    extends FacetComponent.FacetBase {
        public FacetMerger jsonFacetMerger;

        public HeatmapFacet(ResponseBuilder rb, String facetStr) {
            super(rb, "facet.heatmap", facetStr);
            SolrParams params = SolrParams.wrapDefaults((SolrParams)this.localParams, (SolrParams)rb.req.getParams());
            FacetRequest heatmapRequest = SpatialHeatmapFacets.createHeatmapRequest(this.getKey(), this.facetOn, rb, params);
            this.jsonFacetMerger = heatmapRequest.createFacetMerger(null);
        }
    }
}

