/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.ui.util;

import java.util.ArrayList;
import java.util.GregorianCalendar;

public class Formatter {
    public static final String _rcsid = "@(#)$Id: Formatter.java 988245 2010-08-23 18:39:35Z kwright $";

    public static String formatTime(long time) {
        GregorianCalendar c = new GregorianCalendar();
        c.setTimeInMillis(time);
        StringBuilder returnString = new StringBuilder();
        Formatter.writechars(returnString, c.get(2) + 1, 2);
        returnString.append("-");
        Formatter.writechars(returnString, c.get(5), 2);
        returnString.append("-");
        Formatter.writechars(returnString, c.get(1), 4);
        returnString.append(" ");
        Formatter.writechars(returnString, c.get(11), 2);
        returnString.append(":");
        Formatter.writechars(returnString, c.get(12), 2);
        returnString.append(":");
        Formatter.writechars(returnString, c.get(13), 2);
        returnString.append(".");
        Formatter.writechars(returnString, c.get(14), 3);
        return returnString.toString();
    }

    public static String[] formatString(String value, int maxWidth, boolean multiple, boolean ellipsis) {
        ArrayList<String> list = new ArrayList<String>();
        while ((list.size() <= 0 || multiple) && value.length() != 0) {
            if (value.length() <= maxWidth) {
                list.add(value);
                break;
            }
            if (ellipsis && maxWidth >= 4) {
                list.add(value.substring(0, maxWidth - 3) + "...");
                value = value.substring(maxWidth - 3);
                continue;
            }
            list.add(value.substring(0, maxWidth));
            value = value.substring(maxWidth);
        }
        String[] rval = new String[list.size()];
        for (int i = 0; i < rval.length; ++i) {
            rval[i] = (String)list.get(i);
        }
        return rval;
    }

    protected static void writechars(StringBuilder sb, int value, int length) {
        String stuff = Integer.toString(value);
        if (length < stuff.length()) {
            while (length > 0) {
                sb.append('*');
                --length;
            }
            return;
        }
        while (length > stuff.length()) {
            sb.append('0');
            --length;
        }
        sb.append(stuff);
    }
}

