/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.jdo;

import java.io.PrintWriter;
import java.io.Serializable;
import java.rmi.Remote;
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;
import javax.naming.spi.ObjectFactory;
import javax.transaction.Synchronization;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.castor.jdo.conf.JdoConf;
import org.castor.jdo.engine.AbstractConnectionFactory;
import org.castor.jdo.engine.DatabaseRegistry;
import org.castor.transactionmanager.LocalTransactionManager;
import org.castor.util.Messages;
import org.exolab.castor.jdo.DataObjects;
import org.exolab.castor.jdo.Database;
import org.exolab.castor.jdo.DatabaseNotFoundException;
import org.exolab.castor.jdo.PersistenceException;
import org.exolab.castor.jdo.engine.GlobalDatabaseImpl;
import org.exolab.castor.jdo.engine.LocalDatabaseImpl;
import org.exolab.castor.jdo.engine.TxDatabaseMap;
import org.exolab.castor.mapping.MappingException;
import org.exolab.castor.persist.OutputLogInterceptor;
import org.exolab.castor.persist.spi.CallbackInterceptor;
import org.exolab.castor.persist.spi.InstanceFactory;
import org.exolab.castor.persist.spi.LogInterceptor;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

public final class JDO
implements DataObjects,
Referenceable,
ObjectFactory,
Serializable {
    private static final long serialVersionUID = 2816194621638396008L;
    private static final Log LOG = LogFactory.getLog((Class)JDO.class);
    public static final int DEFAULT_LOCK_TIMEOUT = 10;
    private String _jdoConfURI;
    private JdoConf _jdoConf;
    private LogInterceptor _logInterceptor;
    private CallbackInterceptor _callback;
    private InstanceFactory _instanceFactory;
    private int _lockTimeout = 10;
    private String _dbName;
    private String _description = "Castor JDO";
    private TransactionManager _transactionManager = null;
    private ClassLoader _classLoader;
    private EntityResolver _entityResolver;
    private TxDatabaseMap _txDbPool;
    private boolean _autoStore = false;

    public JDO() {
    }

    public JDO(String name) {
        this._dbName = name;
    }

    public void setLogWriter(PrintWriter logWriter) {
        this._logInterceptor = logWriter == null ? null : new OutputLogInterceptor(logWriter);
    }

    public void setLogInterceptor(LogInterceptor logInterceptor) {
        this._logInterceptor = logInterceptor;
    }

    public void setCallbackInterceptor(CallbackInterceptor callback) {
        this._callback = callback;
    }

    public void setInstanceFactory(InstanceFactory factory) {
        this._instanceFactory = factory;
    }

    public LogInterceptor getLogInterceptor() {
        return this._logInterceptor;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this._classLoader = classLoader;
    }

    public ClassLoader getClassLoader() {
        return this._classLoader;
    }

    public void setEntityResolver(EntityResolver entityResolver) {
        this._entityResolver = entityResolver;
    }

    public EntityResolver getEntityResolver() {
        return this._entityResolver;
    }

    public void setDescription(String description) {
        if (description == null) {
            throw new NullPointerException("DataSource: Argument 'description' is null");
        }
        this._description = description;
    }

    public String getDescription() {
        return this._description;
    }

    public void setDatabaseName(String name) {
        this._dbName = name;
    }

    public String getDatabaseName() {
        return this._dbName;
    }

    public void setLockTimeout(int seconds) {
        this._lockTimeout = seconds;
    }

    public int getLockTimeout() {
        return this._lockTimeout;
    }

    public void setConfiguration(String url) {
        this._jdoConfURI = url;
    }

    public void setConfiguration(JdoConf jdoConfiguration) {
        this._jdoConf = jdoConfiguration;
    }

    public String getConfiguration() {
        return this._jdoConfURI;
    }

    public void setDatabasePooling(boolean pool) {
        if (!pool) {
            if (this._txDbPool == null) {
                return;
            }
            if (this._txDbPool.isEmpty()) {
                this._txDbPool = null;
                return;
            }
            throw new IllegalStateException("JDO Pooling started. It can not be set to false");
        }
        if (this._txDbPool == null) {
            this._txDbPool = new TxDatabaseMap();
        }
    }

    public boolean getDatabasePooling() {
        return this._txDbPool != null;
    }

    public void setAutoStore(boolean autoStore) {
        this._autoStore = autoStore;
    }

    public boolean isAutoStore() {
        return this._autoStore;
    }

    public Database getDatabase() throws PersistenceException {
        block14: {
            if (this._dbName == null) {
                throw new IllegalStateException("Called 'getDatabase' without first setting database name");
            }
            try {
                if (!DatabaseRegistry.isDatabaseRegistred(this._dbName)) {
                    if (this._jdoConfURI != null) {
                        DatabaseRegistry.loadDatabase(new InputSource(this._jdoConfURI), this._entityResolver, this._classLoader);
                    } else if (this._jdoConf != null) {
                        DatabaseRegistry.loadDatabase(this._jdoConf, this._entityResolver, this._classLoader, null);
                    } else {
                        throw new DatabaseNotFoundException(Messages.format("jdo.dbNoMapping", this._dbName));
                    }
                }
                AbstractConnectionFactory factory = DatabaseRegistry.getConnectionFactory(this._dbName);
                this._transactionManager = factory.getTransactionManager();
            }
            catch (MappingException ex) {
                throw new DatabaseNotFoundException(ex);
            }
            if (!(this._transactionManager instanceof LocalTransactionManager)) {
                try {
                    Transaction transaction = this._transactionManager.getTransaction();
                    if (this._txDbPool != null && this._txDbPool.containsTx(transaction)) {
                        return this._txDbPool.get(transaction);
                    }
                    if (transaction != null && transaction.getStatus() == 0) {
                        GlobalDatabaseImpl dbImpl = new GlobalDatabaseImpl(this._dbName, this._lockTimeout, this._callback, this._instanceFactory, transaction, this._classLoader, this._autoStore, this.getDatabasePooling());
                        if (this._txDbPool != null) {
                            this._txDbPool.put(transaction, dbImpl);
                        }
                        transaction.registerSynchronization((Synchronization)dbImpl);
                        return dbImpl;
                    }
                }
                catch (Exception ex) {
                    if (this._logInterceptor == null) break block14;
                    this._logInterceptor.exception(ex);
                }
            }
        }
        return new LocalDatabaseImpl(this._dbName, this._lockTimeout, this._callback, this._instanceFactory, this._classLoader, this._autoStore);
    }

    public static void loadConfiguration(String url) throws MappingException {
        DatabaseRegistry.loadDatabase(new InputSource(url), null, null);
    }

    public static void loadConfiguration(String url, ClassLoader loader) throws MappingException {
        DatabaseRegistry.loadDatabase(new InputSource(url), null, loader);
    }

    public static void loadConfiguration(InputSource source, EntityResolver resolver, ClassLoader loader) throws MappingException {
        DatabaseRegistry.loadDatabase(source, resolver, loader);
    }

    public synchronized Reference getReference() throws NamingException {
        if (this._jdoConfURI == null) {
            throw new NamingException("JDO instance does not have a valid configuration URI set.");
        }
        Reference ref = new Reference(this.getClass().getName(), this.getClass().getName(), null);
        if (this._description != null) {
            ref.add(new StringRefAddr("description", this._description));
        }
        if (this._dbName != null) {
            ref.add(new StringRefAddr("databaseName", this._dbName));
        }
        if (this._jdoConfURI != null) {
            ref.add(new StringRefAddr("configuration", this._jdoConfURI));
        }
        ref.add(new StringRefAddr("lockTimeout", Integer.toString(this._lockTimeout)));
        return ref;
    }

    public Object getObjectInstance(Object refObj, Name name, Context nameCtx, Hashtable env) throws NamingException {
        if (refObj instanceof Reference) {
            JDO jdo;
            Reference ref = (Reference)refObj;
            if (!ref.getClassName().equals(this.getClass().getName())) {
                throw new NamingException("Reference not constructed from class " + this.getClass().getName());
            }
            try {
                jdo = (JDO)Class.forName(ref.getClassName()).newInstance();
            }
            catch (Exception ex) {
                throw new NamingException(ex.toString());
            }
            RefAddr addr = ref.get("description");
            if (addr != null) {
                jdo._description = (String)addr.getContent();
            }
            if ((addr = ref.get("databaseName")) != null) {
                jdo._dbName = (String)addr.getContent();
            }
            if ((addr = ref.get("configuration")) != null) {
                jdo._jdoConfURI = (String)addr.getContent();
            }
            if ((addr = ref.get("lockTimeout")) != null) {
                jdo._lockTimeout = Integer.parseInt((String)addr.getContent());
            }
            return jdo;
        }
        if (refObj instanceof Remote) {
            return refObj;
        }
        return null;
    }
}

