/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.core.jsongen;

import java.io.IOException;
import java.io.Reader;
import org.apache.manifoldcf.core.jsongen.JSONArrayReader;
import org.apache.manifoldcf.core.jsongen.JSONDoubleReader;
import org.apache.manifoldcf.core.jsongen.JSONIntegerReader;
import org.apache.manifoldcf.core.jsongen.JSONNameValueReader;
import org.apache.manifoldcf.core.jsongen.JSONObjectReader;
import org.apache.manifoldcf.core.jsongen.JSONReader;
import org.apache.manifoldcf.core.jsongen.JSONStringReader;
import org.junit.Assert;
import org.junit.Test;

public class TestJsonGen {
    @Test
    public void testArrayFormation() throws IOException {
        JSONArrayReader jr = new JSONArrayReader();
        jr.addArrayElement((JSONReader)new JSONStringReader("hello")).addArrayElement((JSONReader)new JSONStringReader("world"));
        this.compare("[\"hello\",\"world\"]", (Reader)jr);
        this.compare("[]", (Reader)new JSONArrayReader());
    }

    @Test
    public void testObjectFormation() throws IOException {
        JSONObjectReader jr = new JSONObjectReader();
        jr.addNameValuePair(new JSONNameValueReader(new JSONStringReader("hi"), (JSONReader)new JSONIntegerReader(1))).addNameValuePair(new JSONNameValueReader(new JSONStringReader("there"), (JSONReader)new JSONDoubleReader(1.0)));
        this.compare("{\"hi\":1,\"there\":1.0}", (Reader)jr);
        this.compare("{}", (Reader)new JSONObjectReader());
    }

    @Test
    public void testStringEscaping() throws IOException {
        this.compare("\"t1\\u000da\"", (Reader)new JSONStringReader("t1\ra"));
        this.compare("\"t2\\u0009\\u0022\\u005c\"", (Reader)new JSONStringReader("t2\t\"\\"));
    }

    protected void compare(String value, Reader reader) throws IOException {
        int character;
        StringBuilder sb = new StringBuilder();
        while ((character = reader.read()) != -1) {
            sb.append((char)character);
        }
        Assert.assertEquals((Object)value, (Object)sb.toString());
    }
}

