/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.microsoft.onenote.fsshttpb.streamobj.chunking;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.streamobj.LeafNodeObject;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.streamobj.SignatureObject;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.streamobj.basic.BinaryItem;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.streamobj.chunking.AbstractChunking;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.unsigned.UInteger;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.unsigned.Unsigned;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.util.ByteUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RDCAnalysisChunking
extends AbstractChunking {
    private static final Logger LOGGER = LoggerFactory.getLogger(RDCAnalysisChunking.class);
    private final int maxChunkSize = 65535;

    public RDCAnalysisChunking(byte[] fileContent) {
        super(fileContent);
    }

    @Override
    public List<LeafNodeObject> chunking() throws IOException {
        int horizon = 16384;
        ArrayList<LeafNodeObject> list = new ArrayList<LeafNodeObject>();
        int inputLength = this.fileContent.length;
        if (inputLength <= 0) {
            throw new IOException("Cannot support the length less than 0");
        }
        if (inputLength <= horizon) {
            list.add(this.getChunk(0L, inputLength));
            return list;
        }
        long chunkStart = 0L;
        UInteger[] hashValues = this.getHashValues();
        while (chunkStart + 1L < (long)inputLength) {
            this.getClass();
            long chunkEndMax = Math.min(chunkStart + 65535L, (long)inputLength);
            long chunkEnd = (int)chunkEndMax;
            for (long n = chunkStart; n < chunkEndMax; ++n) {
                boolean isBoundary = true;
                if (n == chunkStart) {
                    n = chunkStart + (long)horizon;
                }
                this.getClass();
                if (n - chunkStart == 65535L) break;
                long end = Math.min(n + (long)horizon, chunkEndMax);
                for (long i = n - (long)horizon; i < end; ++i) {
                    if (i == n || hashValues[(int)n].intValue() > hashValues[(int)i].intValue()) continue;
                    isBoundary = false;
                    break;
                }
                if (!isBoundary) continue;
                if (n + (long)horizon > (long)inputLength) {
                    n = chunkEndMax;
                    continue;
                }
                if (n - n % (long)horizon + (long)(2 * horizon) > (long)inputLength || inputLength % horizon == 0 && (int)chunkStart - (int)chunkStart % horizon + 2 * horizon == inputLength) continue;
                chunkEnd = n;
                break;
            }
            list.add(this.getChunk(chunkStart, chunkEnd));
            chunkStart = chunkEnd;
        }
        return list;
    }

    private LeafNodeObject getChunk(long chunkStart, long chunkEnd) throws IOException {
        block3: {
            block2: {
                if (chunkEnd <= chunkStart) break block2;
                this.getClass();
                if (chunkEnd - chunkStart <= 65535L && chunkStart <= Integer.MAX_VALUE) break block3;
            }
            throw new IOException("ChunkStart out of range");
        }
        byte[] temp = Arrays.copyOfRange(this.fileContent, (int)chunkStart, (int)(chunkEnd - chunkStart));
        SignatureObject signature = new SignatureObject();
        signature.signatureData = new BinaryItem(ByteUtil.toListOfByte(temp));
        return new LeafNodeObject.IntermediateNodeObjectBuilder().Build(temp, signature);
    }

    private UInteger[] getHashValues() {
        int hashWindowSize = 48;
        UInteger[] hashValues = new UInteger[this.fileContent.length];
        int shiftAmount = this.getShiftAmount(hashWindowSize);
        int[] lookupTable = new int[]{1581218888, 2036993323, -1093841358, 1863718300, 1752371900, 312931082, -1882577310, 2042117396, 1068187440, -1739756382, 1307967084, 1254961558, 1648733473, 974513594, -1864670055, 95079275, 2031941412, 1347213584, -1744226960, 151229151, -241965640, 1107442779, -2136384406, 300316350, -955309801, -288073601, 1685711293, 453788284, 1090815674, 821409847, -111684857, 355856673, -1411096944, 2048571632, 476612580, 1097906106, -1958142995, 1553075827, 455006097, 2047792258, -857184743, 1172075152, 1474761570, 774172700, 168179699, 244077925, 362037266, 888663786, -1134395071, 505415796, -383499399, 1046720202, 2050702542, 1945674309, -684400107, -2091932620, -110491388, -80108508, 200971834, -1692176670, -1575809019, 1052183247, 688372952, 1063804730, 929430839, 471610578, 61428089, 38528707, 101878112, -2075233136, -491556445, 864194716, 1028758135, -1869144375, 1856456165, 1225472604, 2134447863, -1139473583, 605715360, -325860677, 1819313066, -208439471, -425058831, 312459265, -1190721095, 2119804156, 1158276490, -1970016957, 1765068386, -1899581670, -211451479, 1406147987, -1286672535, 139020932, 258866996, 1953667747, 1219839839, -1182344060, -800961395, -1221930871, 182173112, -2108695576, -1716711336, -1728385992, -414833621, 729737212, 773136295, 1678976783, 1760391737, 1999233747, 1452782501, 194029251, -545460273, -556504504, 1184196744, -1279562300, -377006193, -131173193, -923866204, -577368071, 1211028109, 1328820344, 1446688932, 1053272589, 612488264, 1609139972, 1521468800, -2078440980, -1367348995, 1798425782, -1860256300, 1978953789, -427468273, 1636086830, 343558805, 961711688, -378162154, 1018827731, 505668932, -141208954, -1510380673, -1431922774, 703042787, -2023584759, -18090511, -122654515, -480135641, -1938127230, 1774891825, -897156399, -803923306, -65427783, 1836333543, 1691181740, 1248134983, -1646527960, 863800301, -248879008, 929562579, 324377837, 1907105809, -1055013241, 638284037, -1053046260, -854919021, 2033931494, -1982693437, -960684920, -483167469, 947635825, 1630014948, 1989417526, -1437424967, 1836889388, 419384688, -1987588296, 812533741, -136347339, 413720612, -907343777, -1045969047, -714704366, -1668552390, 42434993, 1645468378, 134149365, 1584134429, 1184802712, -1184544201, 481683278, 1381847085, -402264984, -578010336, 2022737039, 1642437774, 496630255, 632687392, 790200456, -535074522, -5992065, -1292234974, -292894428, 413255079, -1217557121, -2001904115, 2067771691, -928441635, 1982492494, 91204913, -336790856, -363541225, 1911926687, -85136223, 145043277, -1151402306, 1540031682, -886755152, 29066795, -1151511312, 1078848331, 59136189, 154767365, -573021496, -1987741841, -808462569, -1094232373, 1387187290, 162283362, 1656866555, 1993093665, -840511448, -2075290991, -1052512596, 245753714, -2007677586, -352082906, 865617757, 1943830791, 1746273744, -779394460, -1823587349, 1508338977, -741463177, 1288695324, 793442157, -1961712887, -2070170603, -195373047, -943928601, -1400300491, 1507533428, -1126755437, 748361477, -883725719, -1300230400, 286462972};
        for (int i = 0; i < this.fileContent.length; ++i) {
            UInteger hashValue = i == 0 ? Unsigned.uint(0) : hashValues[i - 1];
            int trailingEdgeData = i < hashWindowSize ? Unsigned.ubyte(0).intValue() : Unsigned.ubyte(this.fileContent[i - hashWindowSize]).intValue();
            int leadingEdgeData = Unsigned.ubyte(this.fileContent[i]).intValue();
            UInteger val = hashValue.xor(Unsigned.uint(lookupTable[trailingEdgeData])).xor(Unsigned.uint(lookupTable[leadingEdgeData]));
            hashValues[i] = val.leftShift(2).inclusiveOr(val.rightShift(32 - shiftAmount));
        }
        return hashValues;
    }

    private int getShiftAmount(int hashWindowSize) {
        int shiftAmount = 1;
        for (int i = 32; i > 0 && hashWindowSize % i != 0; i /= 2) {
            shiftAmount *= 2;
        }
        return shiftAmount %= 32;
    }
}

