/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.resource.metadata.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import org.apache.uima.UIMAFramework;
import org.apache.uima.analysis_engine.TypeOrFeature;
import org.apache.uima.resource.metadata.Capability;
import org.apache.uima.resource.metadata.LanguagePrecondition;
import org.apache.uima.resource.metadata.MimeTypePrecondition;
import org.apache.uima.resource.metadata.Precondition;
import org.apache.uima.resource.metadata.impl.LanguagePrecondition_impl;
import org.apache.uima.resource.metadata.impl.MetaDataObject_impl;
import org.apache.uima.resource.metadata.impl.MimeTypePrecondition_impl;
import org.apache.uima.resource.metadata.impl.PropertyXmlInfo;
import org.apache.uima.resource.metadata.impl.XmlizationInfo;

public class Capability_impl
extends MetaDataObject_impl
implements Capability {
    static final long serialVersionUID = -2821073595288674925L;
    private static final String[] EMPTY_STRINGS = new String[0];
    private String mDescription;
    private TypeOrFeature[] mInputs = new TypeOrFeature[0];
    private TypeOrFeature[] mOutputs = new TypeOrFeature[0];
    private Precondition[] mPreconditions = new Precondition[0];
    private String[] mInputSofas = EMPTY_STRINGS;
    private String[] mOutputSofas = EMPTY_STRINGS;
    private static final XmlizationInfo XMLIZATION_INFO = new XmlizationInfo("capability", new PropertyXmlInfo[]{new PropertyXmlInfo("description"), new PropertyXmlInfo("inputs", false), new PropertyXmlInfo("outputs", false), new PropertyXmlInfo("inputSofas", "inputSofas", true, "sofaName"), new PropertyXmlInfo("outputSofas", "outputSofas", true, "sofaName"), new PropertyXmlInfo("languagesSupported", "languagesSupported", false, "language"), new PropertyXmlInfo("mimeTypesSupported", "mimeTypesSupported", true, "mimeType")});

    @Override
    public String getDescription() {
        return this.mDescription;
    }

    @Override
    public void setDescription(String aDescription) {
        this.mDescription = aDescription;
    }

    @Override
    public TypeOrFeature[] getInputs() {
        return this.mInputs;
    }

    @Override
    public TypeOrFeature[] getOutputs() {
        return this.mOutputs;
    }

    @Override
    public Precondition[] getPreconditions() {
        return this.mPreconditions;
    }

    @Override
    public String[] getLanguagesSupported() {
        Precondition[] preconditions = this.getPreconditions();
        for (int i = 0; i < preconditions.length; ++i) {
            if (!(preconditions[i] instanceof LanguagePrecondition)) continue;
            return ((LanguagePrecondition)preconditions[i]).getLanguages();
        }
        return EMPTY_STRINGS;
    }

    @Override
    public String[] getMimeTypesSupported() {
        Precondition[] preconditions = this.getPreconditions();
        for (int i = 0; i < preconditions.length; ++i) {
            if (!(preconditions[i] instanceof MimeTypePrecondition)) continue;
            return ((MimeTypePrecondition)preconditions[i]).getMimeTypes();
        }
        return EMPTY_STRINGS;
    }

    @Override
    public void setInputs(TypeOrFeature[] aInputs) {
        this.mInputs = aInputs;
    }

    @Override
    public void setOutputs(TypeOrFeature[] aOutputs) {
        this.mOutputs = aOutputs;
    }

    @Override
    public void setPreconditions(Precondition[] aPreconditions) {
        this.mPreconditions = aPreconditions;
    }

    @Override
    public void setLanguagesSupported(String[] aLanguageIDs) {
        ArrayList<Precondition> preconditions = new ArrayList<Precondition>();
        Precondition[] precondArray = this.getPreconditions();
        if (precondArray != null) {
            preconditions.addAll(Arrays.asList(precondArray));
        }
        Iterator i = preconditions.iterator();
        while (i.hasNext()) {
            Precondition p = (Precondition)i.next();
            if (!(p instanceof LanguagePrecondition)) continue;
            i.remove();
        }
        if (aLanguageIDs != null && aLanguageIDs.length > 0) {
            LanguagePrecondition_impl languagePrecond = new LanguagePrecondition_impl();
            languagePrecond.setLanguages(aLanguageIDs);
            preconditions.add(languagePrecond);
        }
        Precondition[] newPrecondArray = new Precondition[preconditions.size()];
        preconditions.toArray(newPrecondArray);
        this.setPreconditions(newPrecondArray);
    }

    @Override
    public void setMimeTypesSupported(String[] aMimeTypes) {
        ArrayList<Precondition> preconditions = new ArrayList<Precondition>();
        Precondition[] precondArray = this.getPreconditions();
        if (precondArray != null) {
            preconditions.addAll(Arrays.asList(precondArray));
        }
        Iterator i = preconditions.iterator();
        while (i.hasNext()) {
            Precondition p = (Precondition)i.next();
            if (!(p instanceof MimeTypePrecondition)) continue;
            i.remove();
        }
        if (aMimeTypes != null && aMimeTypes.length > 0) {
            MimeTypePrecondition_impl mimeTypePrecond = new MimeTypePrecondition_impl();
            mimeTypePrecond.setMimeTypes(aMimeTypes);
            preconditions.add(mimeTypePrecond);
        }
        Precondition[] newPrecondArray = new Precondition[preconditions.size()];
        preconditions.toArray(newPrecondArray);
        this.setPreconditions(newPrecondArray);
    }

    @Override
    public void addInputType(String aTypeName, boolean aAllAnnotatorFeatures) {
        TypeOrFeature type = UIMAFramework.getResourceSpecifierFactory().createTypeOrFeature();
        type.setType(true);
        type.setName(aTypeName);
        type.setAllAnnotatorFeatures(aAllAnnotatorFeatures);
        TypeOrFeature[] oldArr = this.getInputs();
        TypeOrFeature[] newArr = new TypeOrFeature[oldArr.length + 1];
        System.arraycopy(oldArr, 0, newArr, 0, oldArr.length);
        newArr[newArr.length - 1] = type;
        this.setInputs(newArr);
    }

    @Override
    public void addInputFeature(String aFeatureName) {
        TypeOrFeature feat = UIMAFramework.getResourceSpecifierFactory().createTypeOrFeature();
        feat.setType(false);
        feat.setName(aFeatureName);
        TypeOrFeature[] oldArr = this.getInputs();
        TypeOrFeature[] newArr = new TypeOrFeature[oldArr.length + 1];
        System.arraycopy(oldArr, 0, newArr, 0, oldArr.length);
        newArr[newArr.length - 1] = feat;
        this.setInputs(newArr);
    }

    @Override
    public void addOutputType(String aTypeName, boolean aAllAnnotatorFeatures) {
        TypeOrFeature type = UIMAFramework.getResourceSpecifierFactory().createTypeOrFeature();
        type.setType(true);
        type.setName(aTypeName);
        type.setAllAnnotatorFeatures(aAllAnnotatorFeatures);
        TypeOrFeature[] oldArr = this.getOutputs();
        TypeOrFeature[] newArr = new TypeOrFeature[oldArr.length + 1];
        System.arraycopy(oldArr, 0, newArr, 0, oldArr.length);
        newArr[newArr.length - 1] = type;
        this.setOutputs(newArr);
    }

    @Override
    public void addOutputFeature(String aFeatureName) {
        TypeOrFeature feat = UIMAFramework.getResourceSpecifierFactory().createTypeOrFeature();
        feat.setType(false);
        feat.setName(aFeatureName);
        TypeOrFeature[] oldArr = this.getOutputs();
        TypeOrFeature[] newArr = new TypeOrFeature[oldArr.length + 1];
        System.arraycopy(oldArr, 0, newArr, 0, oldArr.length);
        newArr[newArr.length - 1] = feat;
        this.setOutputs(newArr);
    }

    @Override
    public void addSupportedLanguage(String aLanguage) {
        String[] oldArr = this.getLanguagesSupported();
        String[] newArr = new String[oldArr.length + 1];
        System.arraycopy(oldArr, 0, newArr, 0, oldArr.length);
        newArr[newArr.length - 1] = aLanguage;
        this.setLanguagesSupported(newArr);
    }

    @Override
    public void removeSupportedLanguage(String aLanguage) {
        String[] current = this.getLanguagesSupported();
        for (int i = 0; i < current.length; ++i) {
            if (!current[i].equals(aLanguage)) continue;
            String[] newArr = new String[current.length - 1];
            System.arraycopy(current, 0, newArr, 0, i);
            System.arraycopy(current, i + 1, newArr, i, current.length - i - 1);
            this.setLanguagesSupported(newArr);
            break;
        }
    }

    @Override
    public String[] getInputSofas() {
        return this.mInputSofas;
    }

    @Override
    public String[] getOutputSofas() {
        return this.mOutputSofas;
    }

    @Override
    public void setInputSofas(String[] aInputSofaNames) {
        this.mInputSofas = aInputSofaNames;
    }

    @Override
    public void setOutputSofas(String[] aOutputSofaNames) {
        this.mOutputSofas = aOutputSofaNames;
    }

    @Override
    public void addInputSofa(String aSofaName) {
        String[] oldArr = this.getInputSofas();
        String[] newArr = new String[oldArr.length + 1];
        System.arraycopy(oldArr, 0, newArr, 0, oldArr.length);
        newArr[newArr.length - 1] = aSofaName;
        this.setInputSofas(newArr);
    }

    @Override
    public void addOutputSofa(String aSofaName) {
        String[] oldArr = this.getOutputSofas();
        String[] newArr = new String[oldArr.length + 1];
        System.arraycopy(oldArr, 0, newArr, 0, oldArr.length);
        newArr[newArr.length - 1] = aSofaName;
        this.setOutputSofas(newArr);
    }

    @Override
    protected XmlizationInfo getXmlizationInfo() {
        return XMLIZATION_INFO;
    }
}

