/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.measure;

import javax.measure.Unit;
import javax.measure.UnitConverter;
import javax.measure.quantity.Angle;
import org.apache.sis.internal.util.Numerics;
import org.apache.sis.math.MathFunctions;
import org.apache.sis.measure.AbstractConverter;
import org.apache.sis.measure.ConcatenatedConverter;
import org.apache.sis.measure.ConventionalUnit;
import org.apache.sis.measure.SystemUnit;
import org.apache.sis.measure.Units;
import org.apache.sis.util.resources.Errors;
import org.apache.sis.util.resources.Vocabulary;

class SexagesimalConverter
extends AbstractConverter {
    private static final long serialVersionUID = -2119974989555436361L;
    private static final double EPS = 1.0E-10;
    static final ConventionalUnit<Angle> DM;
    static final Unit<Angle> DMS;
    static final Unit<Angle> DMS_SCALED;
    final boolean hasSeconds;
    final double divider;
    private final UnitConverter inverse;

    private SexagesimalConverter(boolean bl, double d) {
        this.hasSeconds = bl;
        this.divider = d;
        this.inverse = new Inverse(this);
    }

    private SexagesimalConverter(SexagesimalConverter sexagesimalConverter) {
        this.hasSeconds = sexagesimalConverter.hasSeconds;
        this.divider = sexagesimalConverter.divider;
        this.inverse = sexagesimalConverter;
    }

    @Override
    public final UnitConverter inverse() {
        return this.inverse;
    }

    @Override
    public double convert(double d) {
        double d2 = MathFunctions.truncate(d);
        d = (d - d2) * 60.0;
        if (this.hasSeconds) {
            double d3 = MathFunctions.truncate(d);
            d = (d - d3) * 60.0;
            d += (d2 * 100.0 + d3) * 100.0;
        } else {
            d += d2 * 100.0;
        }
        return d / this.divider;
    }

    @Override
    public final double derivative(double d) {
        return Double.NaN;
    }

    public final boolean equals(Object object) {
        return object != null && object.getClass() == this.getClass() && ((SexagesimalConverter)object).divider == this.divider;
    }

    public final int hashCode() {
        return (int)this.divider ^ this.getClass().hashCode();
    }

    static {
        SystemUnit systemUnit = (SystemUnit)Units.RADIAN;
        UnitConverter unitConverter = Units.DEGREE.getConverterTo(systemUnit);
        DM = new ConventionalUnit(systemUnit, new ConcatenatedConverter(new SexagesimalConverter(false, 100.0).inverse(), unitConverter), "D.M", 16, 9111);
        DMS = new ConventionalUnit<Angle>(systemUnit, new ConcatenatedConverter(new SexagesimalConverter(true, 10000.0).inverse(), unitConverter), "D.MS", 16, 9110);
        DMS_SCALED = new ConventionalUnit<Angle>(systemUnit, new ConcatenatedConverter(new SexagesimalConverter(true, 1.0).inverse(), unitConverter), "DMS", 16, 9107);
    }

    private static final class Inverse
    extends SexagesimalConverter {
        private static final long serialVersionUID = -1928146841653975281L;

        public Inverse(SexagesimalConverter sexagesimalConverter) {
            super(sexagesimalConverter);
        }

        private static double fixRoundingError(double d, double d2) {
            int n = Math.getExponent(Math.ulp(d2));
            if (n < 0 && n >= -52) {
                n = Numerics.toExp10(-n);
                double d3 = MathFunctions.pow10(n);
                d = Math.rint(d * d3) / d3;
            }
            return d;
        }

        @Override
        public double convert(double d) throws IllegalArgumentException {
            double d2;
            double d3;
            double d4;
            if (this.hasSeconds) {
                double d5;
                d4 = d5 = d * this.divider;
                d3 = MathFunctions.truncate(d4 / 10000.0);
                d2 = MathFunctions.truncate((d4 -= 10000.0 * d3) / 100.0);
                d4 -= 100.0 * d2;
                d4 = Inverse.fixRoundingError(d4, d5);
            } else {
                double d6;
                d4 = 0.0;
                d2 = d6 = d * this.divider;
                d3 = MathFunctions.truncate(d2 / 100.0);
                d2 -= d3 * 100.0;
                d2 = Inverse.fixRoundingError(d2, d6);
            }
            if (d2 <= -60.0 || d2 >= 60.0) {
                if (Math.abs(Math.abs(d2) - 100.0) <= 1.0E-8) {
                    d3 = d2 >= 0.0 ? (d3 += 1.0) : (d3 -= 1.0);
                    d2 = 0.0;
                } else {
                    throw Inverse.illegalField(d, d2, (short)8);
                }
            }
            if (d4 <= -60.0 || d4 >= 60.0) {
                if (Math.abs(Math.abs(d4) - 100.0) <= 1.0E-8) {
                    d2 = d4 >= 0.0 ? (d2 += 1.0) : (d2 -= 1.0);
                    d4 = 0.0;
                } else {
                    throw Inverse.illegalField(d, d4, (short)9);
                }
            }
            return (d4 / 60.0 + d2) / 60.0 + d3;
        }

        private static IllegalArgumentException illegalField(double d, double d2, short s) {
            return new IllegalArgumentException(Errors.format((short)44, "angle", d, Vocabulary.format(s), d2));
        }
    }
}

