/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.image;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.color.ColorSpace;
import java.awt.image.ColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.Raster;
import java.awt.image.RasterFormatException;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.util.Arrays;
import java.util.Vector;
import org.apache.sis.image.ErrorHandler;
import org.apache.sis.image.ImageProcessor;
import org.apache.sis.image.PlanarImage;
import org.apache.sis.internal.coverage.j2d.ImageUtilities;
import org.apache.sis.internal.coverage.j2d.TileErrorHandler;
import org.apache.sis.internal.coverage.j2d.TileOpExecutor;
import org.apache.sis.internal.util.Numerics;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.resources.Errors;

final class PrefetchedImage
extends PlanarImage
implements TileErrorHandler.Executor {
    final RenderedImage source;
    private final int minTileX;
    private final int minTileY;
    private final int numXTiles;
    private final int numYTiles;
    private final Raster[] tiles;
    private DataBuffer placeholderPixels;
    private ErrorHandler.Report errorReport;

    PrefetchedImage(RenderedImage renderedImage, Rectangle rectangle, ErrorHandler errorHandler, boolean bl) {
        this.source = renderedImage;
        if (rectangle != null) {
            rectangle = new Rectangle(rectangle);
            ImageUtilities.clipBounds(renderedImage, rectangle);
            if (rectangle.isEmpty()) {
                this.minTileX = 0;
                this.minTileY = 0;
                this.numXTiles = 0;
                this.numYTiles = 0;
                this.tiles = null;
                return;
            }
        }
        Worker worker = new Worker(renderedImage, rectangle);
        Rectangle rectangle2 = worker.getTileIndices();
        this.minTileX = rectangle2.x;
        this.minTileY = rectangle2.y;
        this.numXTiles = rectangle2.width;
        this.numYTiles = rectangle2.height;
        this.tiles = new Raster[Math.multiplyExact(this.numYTiles, this.numXTiles)];
        worker.setErrorHandler(errorHandler, ImageProcessor.class, "prefetch");
        if (bl) {
            worker.parallelReadFrom(renderedImage);
        } else {
            worker.readFrom(renderedImage);
        }
        for (int i = 0; i < this.tiles.length; ++i) {
            if (this.tiles[i] != null) continue;
            int n = i % this.numXTiles + this.minTileX;
            int n2 = i / this.numXTiles + this.minTileY;
            this.tiles[i] = this.createPlaceholder(n, n2);
        }
    }

    final boolean isEmpty() {
        return (this.numXTiles | this.numYTiles) == 0;
    }

    @Override
    public Vector<RenderedImage> getSources() {
        Vector<RenderedImage> vector = new Vector<RenderedImage>(1);
        vector.add(this.source);
        return vector;
    }

    @Override
    public Object getProperty(String string) {
        return this.source.getProperty(string);
    }

    @Override
    public String[] getPropertyNames() {
        return this.source.getPropertyNames();
    }

    @Override
    public ColorModel getColorModel() {
        return this.source.getColorModel();
    }

    @Override
    public SampleModel getSampleModel() {
        return this.source.getSampleModel();
    }

    @Override
    public int getWidth() {
        return this.source.getWidth();
    }

    @Override
    public int getHeight() {
        return this.source.getHeight();
    }

    @Override
    public int getMinX() {
        return this.source.getMinX();
    }

    @Override
    public int getMinY() {
        return this.source.getMinY();
    }

    @Override
    public int getNumXTiles() {
        return this.source.getNumXTiles();
    }

    @Override
    public int getNumYTiles() {
        return this.source.getNumYTiles();
    }

    @Override
    public int getMinTileX() {
        return this.source.getMinTileX();
    }

    @Override
    public int getMinTileY() {
        return this.source.getMinTileY();
    }

    @Override
    public int getTileWidth() {
        return this.source.getTileWidth();
    }

    @Override
    public int getTileHeight() {
        return this.source.getTileHeight();
    }

    @Override
    public int getTileGridXOffset() {
        return this.source.getTileGridXOffset();
    }

    @Override
    public int getTileGridYOffset() {
        return this.source.getTileGridYOffset();
    }

    @Override
    public Raster getTile(int n, int n2) {
        int n3;
        int n4 = Math.subtractExact(n, this.minTileX);
        if (n4 >= 0 && n < this.numXTiles && (n3 = Math.subtractExact(n2, this.minTileY)) >= 0 && n2 < this.numYTiles) {
            return this.tiles[n4 + n3 * this.numXTiles];
        }
        try {
            return this.source.getTile(n, n2);
        }
        catch (RuntimeException runtimeException) {
            ErrorHandler.Report report = this.errorReport;
            if (report == null) {
                throw runtimeException;
            }
            report.add(new Point(n, n2), runtimeException, null);
            assert (Thread.holdsLock(this));
            return this.createPlaceholder(n, n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void execute(Runnable runnable, TileErrorHandler tileErrorHandler) {
        ArgumentChecks.ensureNonNull("action", runnable);
        ArgumentChecks.ensureNonNull("errorHandler", tileErrorHandler);
        this.errorReport = new ErrorHandler.Report();
        try {
            runnable.run();
        }
        finally {
            ErrorHandler.Report report = this.errorReport;
            this.errorReport = null;
            tileErrorHandler.publish(report);
        }
    }

    private Raster createPlaceholder(int n, int n2) {
        int n3;
        int n4;
        SampleModel sampleModel = this.getSampleModel();
        Point point = new Point(ImageUtilities.tileToPixelX(this.source, n), ImageUtilities.tileToPixelY(this.source, n2));
        if (this.placeholderPixels != null) {
            return Raster.createRaster(sampleModel, this.placeholderPixels, point);
        }
        double[] dArray = new double[sampleModel.getNumBands()];
        if (ImageUtilities.isIntegerType(sampleModel)) {
            boolean bl = ImageUtilities.isUnsignedType(sampleModel);
            for (n4 = 0; n4 < dArray.length; ++n4) {
                n3 = sampleModel.getSampleSize(n4);
                if (!bl) {
                    --n3;
                }
                dArray[n4] = Numerics.bitmask(n3) - 1L;
            }
        } else {
            ColorSpace colorSpace;
            ColorModel colorModel = this.getColorModel();
            if (colorModel != null && (colorSpace = colorModel.getColorSpace()) != null) {
                n3 = Math.min(colorSpace.getNumComponents(), dArray.length);
                while (--n3 >= 0) {
                    dArray[n3] = colorSpace.getMaxValue(n3);
                }
            } else {
                Arrays.fill(dArray, 1.0);
            }
        }
        WritableRaster writableRaster = WritableRaster.createWritableRaster(sampleModel, sampleModel.createDataBuffer(), point);
        n4 = writableRaster.getWidth();
        n3 = writableRaster.getHeight();
        int n5 = writableRaster.getMinX();
        int n6 = writableRaster.getMinY();
        int n7 = n4 + n5 - 1;
        int n8 = n3 + n6 - 1;
        int n9 = n5;
        while (n9 < n7) {
            writableRaster.setPixel(n9++, n6, dArray);
            writableRaster.setPixel(n9++, n8, dArray);
        }
        int n10 = n6;
        while (n10 < n8) {
            writableRaster.setPixel(n5, n10++, dArray);
            writableRaster.setPixel(n7, n10++, dArray);
        }
        if (n9 == n7) {
            writableRaster.setPixel(n7, n6, dArray);
        }
        if (n10 == n8) {
            writableRaster.setPixel(n5, n8, dArray);
        }
        if (n4 >= n3) {
            double d = (double)n3 / (double)n4;
            for (int i = 0; i < n4; ++i) {
                n9 = n5 + i;
                n10 = (int)((double)i * d);
                writableRaster.setPixel(n9, n6 + n10, dArray);
                writableRaster.setPixel(n9, n8 - n10, dArray);
            }
        } else {
            double d = (double)n4 / (double)n3;
            for (int i = 0; i < n3; ++i) {
                n10 = n6 + i;
                n9 = (int)((double)i * d);
                writableRaster.setPixel(n5 + n9, n10, dArray);
                writableRaster.setPixel(n7 - n9, n10, dArray);
            }
        }
        this.placeholderPixels = writableRaster.getDataBuffer();
        return writableRaster;
    }

    private final class Worker
    extends TileOpExecutor {
        private final long tileWidth;
        private final long tileHeight;
        private final long tileGridXOffset;
        private final long tileGridYOffset;

        Worker(RenderedImage renderedImage, Rectangle rectangle) {
            super(renderedImage, rectangle);
            this.tileWidth = renderedImage.getTileWidth();
            this.tileHeight = renderedImage.getTileHeight();
            this.tileGridXOffset = renderedImage.getTileGridXOffset();
            this.tileGridYOffset = renderedImage.getTileGridYOffset();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void readFrom(Raster raster) {
            long l = Math.floorDiv((long)raster.getMinX() - this.tileGridXOffset, this.tileWidth) - (long)PrefetchedImage.this.minTileX;
            long l2 = Math.floorDiv((long)raster.getMinY() - this.tileGridYOffset, this.tileHeight) - (long)PrefetchedImage.this.minTileY;
            assert (l >= 0L && l < (long)PrefetchedImage.this.numXTiles) : l;
            assert (l2 >= 0L && l2 < (long)PrefetchedImage.this.numYTiles) : l2;
            int n = Math.toIntExact(l + l2 * (long)PrefetchedImage.this.numXTiles);
            Raster[] rasterArray = PrefetchedImage.this.tiles;
            synchronized (rasterArray) {
                if (PrefetchedImage.this.tiles[n] != null) {
                    throw new RasterFormatException(Errors.format((short)24, "Tile[" + l + ", " + l2 + ']'));
                }
                ((PrefetchedImage)PrefetchedImage.this).tiles[n] = raster;
            }
        }
    }
}

