/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.index.tree;

import java.util.Arrays;
import java.util.Spliterator;
import java.util.function.Consumer;
import org.apache.sis.index.tree.PointTree;
import org.apache.sis.index.tree.PointTreeNode;
import org.apache.sis.internal.util.Numerics;
import org.opengis.geometry.Envelope;

class NodeIterator<E>
implements Spliterator<E>,
Cloneable {
    private static final Object[] FINISHED = new Object[0];
    private final PointTree.Locator<? super E> locator;
    private final long bitmask;
    private final double[] bounds;
    private double[] point;
    private Cursor<E> cursor;
    private Object[] current;
    private int nextIndex;
    private Cursor<E> recycle;

    NodeIterator(PointTree<E> pointTree, Envelope envelope) {
        int n = pointTree.getDimension();
        this.bitmask = Numerics.bitmask(1 << n) - 1L;
        this.bounds = new double[n * 2];
        if (envelope != null) {
            this.point = new double[n];
            int n2 = n;
            while (--n2 >= 0) {
                this.bounds[n2] = envelope.getMinimum(n2);
                this.bounds[n2 + n] = envelope.getMaximum(n2);
            }
        } else {
            Arrays.fill(this.bounds, 0, n, Double.NEGATIVE_INFINITY);
            Arrays.fill(this.bounds, n, n * 2, Double.POSITIVE_INFINITY);
        }
        this.locator = pointTree.locator;
        this.cursor = new Cursor(pointTree.treeRegion);
        this.cursor.node = pointTree.root;
        this.cursor.findIntersections(this);
        this.current = this.next();
    }

    private boolean postClone(long l) {
        Cursor<E> cursor = this.cursor;
        if (this.point != null) {
            this.point = new double[this.point.length];
        }
        this.cursor = new Cursor(((Cursor)cursor).region);
        ((Cursor)this.cursor).parent = ((Cursor)cursor).parent;
        this.cursor.node = cursor.node;
        this.cursor.quadrants = l;
        this.recycle = null;
        this.nextIndex = 0;
        this.current = this.next();
        return this.current != null;
    }

    private Object[] next() {
        while (this.cursor != null) {
            while (this.cursor.quadrants != 0L) {
                int n = Long.numberOfTrailingZeros(this.cursor.quadrants);
                this.cursor.quadrants &= (long)(~(1 << n));
                Object object = this.cursor.node.getChild(n);
                if (object == null) continue;
                if (object instanceof Object[]) {
                    return (Object[])object;
                }
                if (this.cursor.quadrants != 0L) {
                    this.cursor = this.cursor.push(this, n);
                } else {
                    this.cursor.moveDown(n);
                }
                this.cursor.node = (PointTreeNode)object;
                this.cursor.findIntersections(this);
            }
            this.cursor = this.cursor.getParentAndRecycle(this);
        }
        return FINISHED;
    }

    @Override
    public final boolean tryAdvance(Consumer<? super E> consumer) {
        Object object;
        while (true) {
            if (this.nextIndex >= this.current.length) {
                if (this.current == FINISHED) {
                    return false;
                }
                this.current = this.next();
                this.nextIndex = 0;
                continue;
            }
            if (this.filter(object = this.current[this.nextIndex++])) break;
        }
        consumer.accept(object);
        return true;
    }

    protected boolean filter(E e) {
        int n;
        this.locator.getPositionOf(e, this.point);
        int n2 = n = this.bounds.length >>> 1;
        while (--n2 >= 0) {
            double d = this.point[n2];
            if (d >= this.bounds[n2] && d <= this.bounds[n2 + n]) continue;
            return false;
        }
        return true;
    }

    @Override
    public final Spliterator<E> trySplit() {
        Cursor<E> cursor = this.cursor;
        if (cursor != null) {
            long l = 0L;
            for (int i = Long.bitCount(cursor.quadrants) / 2; i >= 0; --i) {
                long l2 = Long.lowestOneBit(cursor.quadrants);
                cursor.quadrants &= l2 ^ 0xFFFFFFFFFFFFFFFFL;
                l |= l2;
            }
            if (l != 0L) {
                try {
                    NodeIterator nodeIterator = (NodeIterator)this.clone();
                    if (nodeIterator.postClone(l)) {
                        return nodeIterator;
                    }
                }
                catch (CloneNotSupportedException cloneNotSupportedException) {
                    throw new AssertionError((Object)cloneNotSupportedException);
                }
            }
        }
        return null;
    }

    @Override
    public long estimateSize() {
        return Long.MAX_VALUE;
    }

    @Override
    public int characteristics() {
        return 257;
    }

    private static final class Cursor<E> {
        private Cursor<E> parent;
        PointTreeNode node;
        long quadrants;
        private final double[] region;
        private static final long[] CLEAR_MASKS = new long[]{0x5555555555555555L, 0x3333333333333333L, 0xF0F0F0F0F0F0F0FL, 0xFF00FF00FF00FFL, 0xFFFF0000FFFFL, 0xFFFFFFFFL};

        Cursor(double[] dArray) {
            this.region = (double[])dArray.clone();
        }

        final void findIntersections(NodeIterator<E> nodeIterator) {
            int n;
            double[] dArray = ((NodeIterator)nodeIterator).bounds;
            this.quadrants = ((NodeIterator)nodeIterator).bitmask;
            int n2 = n = dArray.length >>> 1;
            while (--n2 >= 0) {
                double d = this.region[n2];
                if (!(dArray[n2] <= d)) {
                    this.quadrants &= CLEAR_MASKS[n2];
                }
                if (dArray[n2 + n] >= d) continue;
                this.quadrants &= CLEAR_MASKS[n2] ^ 0xFFFFFFFFFFFFFFFFL;
            }
        }

        final Cursor<E> push(NodeIterator<E> nodeIterator, int n) {
            Cursor<E> cursor = ((NodeIterator)nodeIterator).recycle;
            if (cursor == null) {
                cursor = new Cursor<E>(this.region);
            } else {
                ((NodeIterator)nodeIterator).recycle = cursor.parent;
                System.arraycopy(this.region, 0, cursor.region, 0, this.region.length);
            }
            PointTreeNode.enterQuadrant(cursor.region, n);
            cursor.parent = this;
            return cursor;
        }

        final void moveDown(int n) {
            PointTreeNode.enterQuadrant(this.region, n);
        }

        final Cursor<E> getParentAndRecycle(NodeIterator<E> nodeIterator) {
            Cursor<E> cursor = this.parent;
            this.parent = ((NodeIterator)nodeIterator).recycle;
            ((NodeIterator)nodeIterator).recycle = this;
            return cursor;
        }
    }
}

