/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.cas.impl;

import java.util.ListIterator;
import java.util.NoSuchElementException;
import org.apache.uima.cas.FSIterator;
import org.apache.uima.cas.FeatureStructure;

class FSListIteratorImpl<T extends FeatureStructure>
implements ListIterator<T> {
    private FSIterator<T> forward;
    private FSIterator<T> back;

    public FSListIteratorImpl(FSIterator<T> it) {
        this.forward = it;
        this.back = it.copy();
        it.moveToPrevious();
    }

    @Override
    public boolean hasNext() {
        return this.forward.isValid();
    }

    @Override
    public boolean hasPrevious() {
        return this.back.isValid();
    }

    public void moveToEnd() {
        this.back.moveToLast();
        this.forward.moveToLast();
        this.forward.moveToNext();
    }

    public void moveToStart() {
        this.forward.moveToFirst();
        this.back.moveToFirst();
        this.back.moveToPrevious();
    }

    @Override
    public T next() throws NoSuchElementException {
        if (!this.forward.isValid()) {
            throw new NoSuchElementException();
        }
        this.forward.moveToNext();
        if (this.back.isValid()) {
            this.back.moveToNext();
        } else {
            this.back.moveToFirst();
        }
        return this.back.get();
    }

    @Override
    public T previous() throws NoSuchElementException {
        if (!this.back.isValid()) {
            throw new NoSuchElementException();
        }
        this.back.moveToPrevious();
        if (this.forward.isValid()) {
            this.forward.moveToPrevious();
        } else {
            this.forward.moveToLast();
        }
        return this.forward.get();
    }

    @Override
    public void add(T o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int nextIndex() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int previousIndex() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void set(T o) {
        throw new UnsupportedOperationException();
    }
}

