/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.util;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import org.apache.uima.UIMAFramework;
import org.apache.uima.analysis_engine.AnalysisEngine;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.impl.CASImpl;
import org.apache.uima.resource.CasDefinition;
import org.apache.uima.resource.CasManager;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.resource.ResourceManager;
import org.apache.uima.resource.metadata.ProcessingResourceMetaData;
import org.apache.uima.util.CasCreationUtils;
import org.apache.uima.util.Level;

public class CasPool {
    private static final String LOG_RESOURCE_BUNDLE = "org.apache.uima.impl.log_messages";
    private static final Class<CasPool> CLASS_NAME = CasPool.class;
    private final Set<CAS> mAllInstances;
    private final Set<CAS> mFreeInstances;
    private final int mNumInstances;
    private final Semaphore permits;

    private CasPool(int aNumInstances, Set<CAS> allInstances) {
        this.mNumInstances = aNumInstances;
        this.permits = new Semaphore(this.mNumInstances, true);
        this.mAllInstances = allInstances;
        Set free = Collections.newSetFromMap(new ConcurrentHashMap());
        free.addAll(this.mAllInstances);
        this.mFreeInstances = free;
    }

    public CasPool(int aNumInstances, Collection<? extends ProcessingResourceMetaData> aCollectionOfProcessingResourceMetaData, Properties aPerformanceTuningSettings, ResourceManager aResourceManager) throws ResourceInitializationException {
        this(aNumInstances, CasPool.fillPool(aNumInstances, aCollectionOfProcessingResourceMetaData, aPerformanceTuningSettings, aResourceManager));
    }

    public CasPool(int aNumInstances, AnalysisEngine aAnalysisEngine) throws ResourceInitializationException {
        this(aNumInstances, CasPool.fillPool(aNumInstances, Collections.singletonList((ProcessingResourceMetaData)aAnalysisEngine.getMetaData()), aAnalysisEngine.getPerformanceTuningSettings(), aAnalysisEngine.getResourceManager()));
    }

    public CasPool(int aNumInstances, ProcessingResourceMetaData aMetaData) throws ResourceInitializationException {
        this(aNumInstances, CasPool.fillPool(aNumInstances, Collections.singletonList(aMetaData), null, null));
    }

    public CasPool(int aNumInstances, ProcessingResourceMetaData aMetaData, ResourceManager aResourceManager) throws ResourceInitializationException {
        this(aNumInstances, CasPool.fillPool(aNumInstances, Collections.singletonList(aMetaData), null, aResourceManager));
    }

    public CasPool(int aNumInstances, CasDefinition aCasDefinition, Properties aPerformanceTuningSettings) throws ResourceInitializationException {
        this(aNumInstances, CasPool.fillPool(aNumInstances, aCasDefinition, aPerformanceTuningSettings));
    }

    public CasPool(int aNumInstances, CasManager aCasManager, Properties aPerformanceTuningSettings) throws ResourceInitializationException {
        this(aNumInstances, CasPool.fillPool(aNumInstances, aCasManager, aPerformanceTuningSettings));
    }

    public CAS getCas() {
        boolean gotPermit = this.permits.tryAcquire();
        if (!gotPermit) {
            return null;
        }
        return this.getCasAfterPermitAcquired();
    }

    public CAS getCas(long aTimeout) {
        boolean gotIt;
        if (aTimeout == 0L) {
            this.permits.acquireUninterruptibly();
            return this.getCasAfterPermitAcquired();
        }
        try {
            gotIt = this.permits.tryAcquire(aTimeout, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            return null;
        }
        if (!gotIt) {
            return null;
        }
        return this.getCasAfterPermitAcquired();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CAS getCasAfterPermitAcquired() {
        Set<CAS> set = this.mFreeInstances;
        synchronized (set) {
            Iterator<CAS> freeIterator = this.mFreeInstances.iterator();
            if (!freeIterator.hasNext()) {
                throw new RuntimeException("internal error");
            }
            CAS cas = freeIterator.next();
            freeIterator.remove();
            return cas;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseCas(CAS aCas) {
        aCas.setCurrentComponentInfo(null);
        CAS cas = aCas.getView("_InitialView");
        Object object = cas;
        synchronized (object) {
            if (!this.mAllInstances.contains(cas) || this.mFreeInstances.contains(cas)) {
                UIMAFramework.getLogger(CLASS_NAME).logrb(Level.WARNING, CLASS_NAME.getName(), "releaseCas", LOG_RESOURCE_BUNDLE, "UIMA_return_cas_to_pool__WARNING");
            } else {
                ((CASImpl)cas).restoreClassLoaderUnlockCas();
                cas.reset();
                this.mFreeInstances.add(cas);
                this.permits.release();
            }
        }
        object = this;
        synchronized (object) {
            this.notifyAll();
        }
    }

    public int getSize() {
        return this.mNumInstances;
    }

    public int getNumAvailable() {
        return this.mFreeInstances.size();
    }

    private static Set<CAS> fillPool(int aNumInstances, Collection<? extends ProcessingResourceMetaData> mdList, Properties performanceTuningSettings, ResourceManager resourceManager) throws ResourceInitializationException {
        CasDefinition casDef = new CasDefinition(mdList, resourceManager);
        return CasPool.fillPool(aNumInstances, casDef, performanceTuningSettings);
    }

    private static Set<CAS> fillPool(int aNumInstances, CasDefinition casDef, Properties performanceTuningSettings) throws ResourceInitializationException {
        CAS c0 = CasCreationUtils.createCas(casDef, performanceTuningSettings);
        HashSet<CAS> all = new HashSet<CAS>(aNumInstances);
        ((CASImpl)c0).setOwner(casDef.getCasManager());
        all.add(c0);
        for (int i = 1; i < aNumInstances; ++i) {
            CAS c = CasCreationUtils.createCas(casDef, performanceTuningSettings, c0.getTypeSystem());
            ((CASImpl)c).setOwner(casDef.getCasManager());
            all.add(c);
        }
        return all;
    }

    private static Set<CAS> fillPool(int aNumInstances, CasManager casManager, Properties performanceTuningSettings) throws ResourceInitializationException {
        HashSet<CAS> all = new HashSet<CAS>(aNumInstances);
        for (int i = 0; i < aNumInstances; ++i) {
            CAS c = casManager.createNewCas(performanceTuningSettings);
            ((CASImpl)c).setOwner(casManager);
            all.add(c);
        }
        return all;
    }

    protected Vector<CAS> getAllInstances() {
        return new Vector<CAS>(this.mAllInstances);
    }

    protected Vector<CAS> getFreeInstances() {
        return new Vector<CAS>(this.mFreeInstances);
    }
}

