/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.svn.svnexe.command.mkdir;

import java.util.ArrayList;
import java.util.List;
import org.apache.maven.scm.ScmFile;
import org.apache.maven.scm.ScmFileStatus;
import org.apache.maven.scm.log.ScmLogger;
import org.codehaus.plexus.util.cli.StreamConsumer;

public class SvnMkdirConsumer
implements StreamConsumer {
    private ScmLogger logger;
    private static final String COMMITTED_REVISION_TOKEN = "Committed revision";
    private int revision;
    private List createdDirs = new ArrayList();

    public SvnMkdirConsumer(ScmLogger logger) {
        this.logger = logger;
    }

    public void consumeLine(String line) {
        String statusString = line.substring(0, 1);
        if (line.startsWith(COMMITTED_REVISION_TOKEN)) {
            String revisionString = line.substring(COMMITTED_REVISION_TOKEN.length() + 1, line.length() - 1);
            this.revision = Integer.parseInt(revisionString);
            return;
        }
        if (!statusString.equals("A")) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info("Unknown line: '" + line + "'");
            }
            return;
        }
        String file = line.substring(3);
        ScmFileStatus status = ScmFileStatus.ADDED;
        this.createdDirs.add(new ScmFile(file, status));
    }

    public int getRevision() {
        return this.revision;
    }

    public List getCreatedDirs() {
        return this.createdDirs;
    }
}

