/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.setup;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.nio.charset.Charset;
import java.text.DateFormat;
import java.text.FieldPosition;
import java.text.Format;
import java.util.Arrays;
import java.util.Date;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Set;
import java.util.SortedMap;
import java.util.TimeZone;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.zip.ZipFile;
import org.apache.sis.internal.system.DataDirectory;
import org.apache.sis.internal.system.Loggers;
import org.apache.sis.internal.system.Shutdown;
import org.apache.sis.internal.util.MetadataServices;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.Exceptions;
import org.apache.sis.util.Version;
import org.apache.sis.util.collection.DefaultTreeTable;
import org.apache.sis.util.collection.TableColumn;
import org.apache.sis.util.collection.TreeTable;
import org.apache.sis.util.collection.TreeTables;
import org.apache.sis.util.logging.LoggerFactory;
import org.apache.sis.util.logging.Logging;
import org.apache.sis.util.resources.Messages;
import org.apache.sis.util.resources.Vocabulary;

public enum About {
    VERSIONS(219),
    LOCALIZATION(119),
    PLUGINS(160),
    LOGGING(121),
    PATHS(159),
    LIBRARIES(115);

    private final short resourceKey;

    private About(short s) {
        this.resourceKey = s;
    }

    public static TreeTable configuration() {
        return About.configuration(EnumSet.allOf(About.class), null, null);
    }

    /*
     * WARNING - void declaration
     */
    public static TreeTable configuration(Set<About> set, Locale locale, TimeZone timeZone) {
        Locale locale2;
        ArgumentChecks.ensureNonNull("sections", set);
        if (locale != null) {
            locale2 = locale;
        } else {
            locale = Locale.getDefault(Locale.Category.DISPLAY);
            locale2 = Locale.getDefault(Locale.Category.FORMAT);
        }
        String string = null;
        String string2 = null;
        Date date = new Date();
        Vocabulary vocabulary = Vocabulary.getResources(locale);
        DefaultTreeTable defaultTreeTable = new DefaultTreeTable(TableColumn.NAME, TableColumn.VALUE_AS_TEXT);
        TreeTable.Node node = defaultTreeTable.getRoot();
        node.setValue(TableColumn.NAME, vocabulary.getString((short)117));
        defaultTreeTable.setRoot(node);
        TreeTable.Node node2 = null;
        About about = VERSIONS;
        int n = 0;
        block33: while (true) {
            Object object2;
            short s = 0;
            String string3 = null;
            Object object3 = null;
            String[] stringArray = null;
            switch (n) {
                case 0: {
                    if (!set.contains((Object)VERSIONS)) break;
                    string3 = "Apache SIS";
                    object3 = Version.SIS;
                    break;
                }
                case 1: {
                    if (!set.contains((Object)VERSIONS)) break;
                    string3 = "Java";
                    object3 = About.concatenate(System.getProperty("java.version"), System.getProperty("java.vendor"), true);
                    break;
                }
                case 2: {
                    if (!set.contains((Object)VERSIONS)) break;
                    string3 = "JavaFX";
                    object3 = System.getProperty("javafx.version");
                    break;
                }
                case 3: {
                    if (!set.contains((Object)VERSIONS)) break;
                    s = 150;
                    object3 = About.concatenate(About.concatenate(System.getProperty("os.name"), System.getProperty("os.version"), false), System.getProperty("os.arch"), true);
                    break;
                }
                case 4: {
                    if (!set.contains((Object)VERSIONS)) break;
                    s = 33;
                    object3 = Shutdown.getContainer();
                    break;
                }
                case 5: {
                    if (!set.contains((Object)VERSIONS)) break;
                    s = 91;
                    object3 = MetadataServices.getInstance().getInformation("EPSG", locale);
                    break;
                }
                case 6: {
                    about = LOCALIZATION;
                    if (!set.contains((Object)LOCALIZATION) || (object2 = Locale.getDefault()) == null) break;
                    s = 118;
                    object3 = ((Locale)object2).getDisplayName(locale);
                    CharSequence charSequence = About.concatenate(About.getCode(locale, false), About.getCode(locale, true), true);
                    if (charSequence == null) break;
                    stringArray = new String[]{vocabulary.getString((short)29, "ISO"), charSequence.toString()};
                    break;
                }
                case 7: {
                    void var21_40;
                    if (!set.contains((Object)LOCALIZATION) || (object2 = TimeZone.getDefault()) == null) break;
                    s = 197;
                    boolean bl = ((TimeZone)object2).inDaylightTime(date);
                    object3 = About.concatenate(((TimeZone)object2).getDisplayName(bl, 1, locale), ((TimeZone)object2).getID(), true);
                    DateFormat dateFormat = DateFormat.getTimeInstance(3, locale2);
                    dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
                    int n2 = ((TimeZone)object2).getOffset(date.getTime());
                    StringBuffer stringBuffer = About.format(dateFormat, n2, new StringBuffer("UTC "));
                    if ((n2 -= ((TimeZone)object2).getRawOffset()) != 0) {
                        StringBuffer stringBuffer2 = About.format(dateFormat, n2, stringBuffer.append(" (").append(vocabulary.getString((short)55)).append(' ')).append(')');
                    }
                    stringArray = new String[]{vocabulary.getString((short)149), var21_40.toString()};
                    break;
                }
                case 8: {
                    if (!set.contains((Object)LOCALIZATION)) break;
                    s = 43;
                    object2 = DateFormat.getDateTimeInstance(1, 1, locale2);
                    if (timeZone != null) {
                        ((DateFormat)object2).setTimeZone(timeZone);
                    }
                    object3 = ((DateFormat)object2).format(date);
                    break;
                }
                case 9: {
                    if (!set.contains((Object)LOCALIZATION) || (object2 = Charset.defaultCharset()) == null) break;
                    s = 25;
                    object3 = ((Charset)object2).displayName(locale);
                    Set<String> set2 = ((Charset)object2).aliases();
                    if (set2 == null || set2.isEmpty()) break;
                    StringBuilder stringBuilder = new StringBuilder((String)object3);
                    String string4 = " (";
                    for (String string5 : set2) {
                        stringBuilder.append(string4).append(string5);
                        string4 = ", ";
                    }
                    object3 = stringBuilder.append(')');
                    break;
                }
                case 10: {
                    about = PLUGINS;
                    if (set.contains((Object)PLUGINS)) {
                        try {
                            stringArray = (String[])Class.forName("org.apache.sis.internal.storage.Capability").getMethod("providers", Locale.class, Vocabulary.class).invoke(null, locale, vocabulary);
                            object3 = vocabulary.getString((short)78, stringArray.length / 2);
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            Logging.recoverableException(Logging.getLogger("org.apache.sis.storage"), About.class, "configuration", classNotFoundException);
                        }
                        catch (ReflectiveOperationException reflectiveOperationException) {
                            object3 = Exceptions.unwrap(reflectiveOperationException).toString();
                        }
                    }
                    s = 50;
                    break;
                }
                case 11: {
                    about = LOGGING;
                    if (!set.contains((Object)LOGGING)) break;
                    s = 104;
                    object2 = Logging.getLoggerFactory();
                    object3 = object2 != null ? ((LoggerFactory)object2).getName() : "java.util.logging";
                    break;
                }
                case 12: {
                    if (!set.contains((Object)LOGGING)) break;
                    s = 114;
                    object2 = Logging.getLogger("").getLevel();
                    if (object2 == null) {
                        object3 = vocabulary.getString((short)207);
                        break;
                    }
                    object3 = ((Level)object2).getLocalizedName();
                    SortedMap<String, Level> sortedMap = Loggers.getEffectiveLevels();
                    if (sortedMap.size() == 1 && ((Level)object2).equals(sortedMap.get("org.apache.sis"))) break;
                    int n3 = 0;
                    stringArray = new String[sortedMap.size() * 2];
                    for (Map.Entry entry : sortedMap.entrySet()) {
                        stringArray[n3++] = (String)entry.getKey();
                        stringArray[n3++] = ((Level)entry.getValue()).getLocalizedName();
                    }
                    break;
                }
                case 13: {
                    about = PATHS;
                    if (!set.contains((Object)PATHS)) break;
                    s = 212;
                    string = System.getProperty("user.home");
                    object3 = string;
                    break;
                }
                case 14: {
                    if (!set.contains((Object)PATHS)) break;
                    s = 44;
                    object3 = System.getProperty("user.dir");
                    break;
                }
                case 15: {
                    if (!set.contains((Object)PATHS)) break;
                    s = 49;
                    try {
                        object3 = DataDirectory.getenv();
                    }
                    catch (SecurityException securityException) {
                        object3 = securityException.toString();
                    }
                    if (object3 == null) {
                        object3 = Messages.getResources(locale).getString((short)16, "SIS_DATA");
                        break;
                    }
                    object2 = DataDirectory.getRootDirectory();
                    if (object2 != null) {
                        object3 = object2.toString();
                        break;
                    }
                    object3 = object3 + " (" + vocabulary.getString((short)107) + ')';
                    break;
                }
                case 16: {
                    if (!set.contains((Object)PATHS)) break;
                    s = 48;
                    object3 = MetadataServices.getInstance().getInformation("DataSource", locale);
                    break;
                }
                case 17: {
                    if (!set.contains((Object)PATHS)) break;
                    s = 193;
                    object3 = System.getProperty("java.io.tmpdir");
                    break;
                }
                case 18: {
                    if (!set.contains((Object)PATHS)) break;
                    s = 110;
                    string2 = System.getProperty("java.home");
                    object3 = string2;
                    break;
                }
                case 19: {
                    about = LIBRARIES;
                    if (!set.contains((Object)LIBRARIES)) break;
                    s = 109;
                    object3 = About.classpath(System.getProperty("java.ext.dirs"), true);
                    break;
                }
                case 20: {
                    if (!set.contains((Object)LIBRARIES)) break;
                    s = 27;
                    object3 = About.classpath(System.getProperty("java.class.path"), false);
                    break;
                }
                default: {
                    break block33;
                }
            }
            if (object3 != null) {
                if (about != null) {
                    node2 = node.newChild();
                    node2.setValue(TableColumn.NAME, vocabulary.getString(about.resourceKey));
                    about = null;
                }
                if (string3 == null) {
                    string3 = vocabulary.getString(s);
                }
                object2 = node2.newChild();
                object2.setValue(TableColumn.NAME, string3);
                if (stringArray != null) {
                    for (int i = 0; i < stringArray.length; i += 2) {
                        String string6 = stringArray[i + 1];
                        if (string6 == null) continue;
                        TreeTable.Node node3 = object2.newChild();
                        node3.setValue(TableColumn.NAME, stringArray[i]);
                        node3.setValue(TableColumn.VALUE_AS_TEXT, string6);
                    }
                }
                if (!(object3 instanceof Map)) {
                    object2.setValue(TableColumn.VALUE_AS_TEXT, object3.toString());
                } else {
                    Map map = (Map)object3;
                    int n4 = 0;
                    block37: while (true) {
                        void var21_46;
                        short s2;
                        LoggerFactory<?> loggerFactory = null;
                        switch (n4) {
                            case 0: {
                                String string6 = string2;
                                s2 = 110;
                                break;
                            }
                            case 1: {
                                String string7 = string;
                                s2 = 212;
                                break;
                            }
                            case 2: {
                                String string8 = "";
                                s2 = 0;
                                loggerFactory = object2;
                                break;
                            }
                            default: {
                                break block37;
                            }
                        }
                        if (var21_46 != null) {
                            File file = var21_46.isEmpty() ? null : new File((String)var21_46);
                            Iterator iterator = map.entrySet().iterator();
                            while (iterator.hasNext()) {
                                CharSequence charSequence;
                                Map.Entry entry = iterator.next();
                                File file2 = (File)entry.getKey();
                                if (file != null && (file2 = About.relativize(file, file2)) == null) continue;
                                if (loggerFactory == null) {
                                    loggerFactory = object2.newChild();
                                    loggerFactory.setValue(TableColumn.NAME, About.parenthesis(vocabulary.getString(s2)));
                                }
                                if ((charSequence = (CharSequence)entry.getValue()) == null || charSequence.length() == 0) {
                                    charSequence = About.parenthesis(vocabulary.getString(file2.isDirectory() ? (short)66 : 210).toLowerCase(locale));
                                }
                                TreeTables.nodeForPath((TreeTable.Node)((Object)loggerFactory), TableColumn.NAME, file2).setValue(TableColumn.VALUE_AS_TEXT, charSequence);
                                iterator.remove();
                            }
                            if (loggerFactory != null) {
                                About.concatenateSingletons((TreeTable.Node)((Object)loggerFactory), true);
                                About.omitMavenRedundancy((TreeTable.Node)((Object)loggerFactory));
                            }
                        }
                        ++n4;
                    }
                }
            }
            ++n;
        }
        TreeTables.replaceCharSequences(defaultTreeTable, locale);
        return defaultTreeTable;
    }

    private static Map<File, CharSequence> classpath(String string, boolean bl) {
        LinkedHashMap<File, CharSequence> linkedHashMap = new LinkedHashMap<File, CharSequence>();
        return About.classpath(string, null, bl, linkedHashMap) ? linkedHashMap : null;
    }

    /*
     * WARNING - void declaration
     */
    private static boolean classpath(String string, File file, boolean bl, Map<File, CharSequence> map) {
        void var5_7;
        Object object;
        Object object2;
        Object object3;
        File file2;
        if (string == null) {
            return false;
        }
        boolean bl2 = false;
        for (CharSequence charSequence : CharSequences.split(string, file == null ? File.pathSeparatorChar : (char)' ')) {
            file2 = new File(file, charSequence.toString());
            if (!file2.exists()) continue;
            if (!bl) {
                if (map.containsKey(file2)) continue;
                map.put(file2, null);
                bl2 = true;
                continue;
            }
            object3 = new JARFilter();
            object2 = file2.listFiles((FileFilter)object3);
            if (object2 == null) continue;
            Arrays.sort((Object[])object2);
            object = object2;
            int n = ((Object[])object).length;
            for (int i = 0; i < n; ++i) {
                Object object4 = object[i];
                if (map.containsKey(object4)) continue;
                map.put((File)object4, null);
                bl2 = true;
            }
        }
        if (!bl2) {
            return false;
        }
        Object var5_6 = null;
        for (Map.Entry<File, CharSequence> entry : map.entrySet()) {
            CharSequence charSequence;
            charSequence = entry.getValue();
            if (charSequence != null || !(file2 = entry.getKey()).isFile() || !file2.canRead()) continue;
            try {
                object3 = new JarFile(file2);
                try {
                    object2 = ((JarFile)object3).getManifest();
                    if (object2 == null || (object = ((Manifest)object2).getMainAttributes()) == null) continue;
                    charSequence = About.concatenate(((Attributes)object).getValue(Attributes.Name.IMPLEMENTATION_TITLE), ((Attributes)object).getValue(Attributes.Name.IMPLEMENTATION_VERSION), false);
                    if (charSequence == null && (charSequence = About.concatenate(((Attributes)object).getValue(Attributes.Name.SPECIFICATION_TITLE), ((Attributes)object).getValue(Attributes.Name.SPECIFICATION_VERSION), false)) == null) {
                        charSequence = "";
                    }
                    entry.setValue(charSequence);
                    if (!About.classpath(((Attributes)object).getValue(Attributes.Name.CLASS_PATH), file2.getParentFile(), false, map)) continue;
                    break;
                }
                finally {
                    ((ZipFile)object3).close();
                }
            }
            catch (IOException iOException) {
                if (var5_7 == null) {
                    IOException iOException2 = iOException;
                    continue;
                }
                var5_7.addSuppressed(iOException);
            }
        }
        if (var5_7 != null) {
            Logging.unexpectedException(Logging.getLogger("org.apache.sis.util"), About.class, "configuration", (Throwable)var5_7);
        }
        return true;
    }

    private static void omitMavenRedundancy(TreeTable.Node node) {
        int n;
        int n2;
        for (TreeTable.Node node2 : node.getChildren()) {
            About.omitMavenRedundancy(node2);
        }
        CharSequence charSequence = node.getValue(TableColumn.NAME);
        int n3 = CharSequences.lastIndexOf(charSequence, File.separatorChar, 0, n2 = charSequence.length());
        if (n3 >= 0 && (n = CharSequences.lastIndexOf(charSequence, File.separatorChar, 0, n3)) >= 0) {
            int n4 = CharSequences.lastIndexOf(charSequence, File.separatorChar, 0, n) + 1;
            StringBuilder stringBuilder = new StringBuilder(n3 - n4).append(charSequence, n4, n3);
            stringBuilder.setCharAt(n - n4, '-');
            if (CharSequences.regionMatches(charSequence, n3 + 1, stringBuilder)) {
                stringBuilder.setLength(0);
                node.setValue(TableColumn.NAME, stringBuilder.append(charSequence, 0, n4).append("(\u2026)").append(charSequence, n3, n2));
            }
        }
    }

    private static TreeTable.Node concatenateSingletons(TreeTable.Node node, boolean bl) {
        List list = (List)node.getChildren();
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            list.set(i, About.concatenateSingletons((TreeTable.Node)list.get(i), false));
        }
        if (!bl && n == 1 && node.getValue(TableColumn.VALUE_AS_TEXT) == null) {
            TreeTable.Node node2 = (TreeTable.Node)list.remove(0);
            StringBuilder stringBuilder = new StringBuilder(node.getValue(TableColumn.NAME));
            if (!File.separator.contentEquals(stringBuilder)) {
                stringBuilder.append(File.separatorChar);
            }
            node2.setValue(TableColumn.NAME, stringBuilder.append(node2.getValue(TableColumn.NAME)));
            return node2;
        }
        return node;
    }

    private static CharSequence concatenate(CharSequence charSequence, CharSequence charSequence2, boolean bl) {
        if (charSequence != null && charSequence.length() != 0) {
            if (charSequence2 != null && charSequence2.length() != 0) {
                StringBuilder stringBuilder = charSequence instanceof StringBuilder ? (StringBuilder)charSequence : new StringBuilder(charSequence);
                stringBuilder.append(' ');
                if (bl) {
                    stringBuilder.append('(');
                }
                stringBuilder.append(charSequence2);
                if (bl) {
                    stringBuilder.append(')');
                }
                return stringBuilder;
            }
            return charSequence;
        }
        return charSequence2;
    }

    private static CharSequence parenthesis(String string) {
        return new StringBuilder(string.length() + 2).append('(').append(string).append(')');
    }

    private static String getCode(Locale locale, boolean bl) {
        try {
            return bl ? locale.getCountry() : locale.getISO3Language();
        }
        catch (MissingResourceException missingResourceException) {
            Logging.ignorableException(Logging.getLogger("org.apache.sis.util.resources"), About.class, "configuration", missingResourceException);
            return null;
        }
    }

    private static StringBuffer format(Format format, int n, StringBuffer stringBuffer) {
        return format.format(Math.abs(n), stringBuffer.append(n < 0 ? (char)'-' : '+').append(' '), new FieldPosition(0));
    }

    private static File relativize(File file, File file2) {
        File file3 = file2.getParentFile();
        if (file3 == null) {
            return null;
        }
        if (file.equals(file3)) {
            file3 = null;
        } else if ((file3 = About.relativize(file, file3)) == null) {
            return null;
        }
        return new File(file3, file2.getName());
    }

    private static final class JARFilter
    implements FileFilter {
        private JARFilter() {
        }

        @Override
        public boolean accept(File file) {
            return file.getName().endsWith(".jar");
        }
    }
}

