/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.crawler.notifications.email;

import java.util.List;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;

public class EmailSession {
    protected final String server;
    protected final int port;
    protected final String username;
    protected final String password;
    protected final Properties properties;
    private Session session = null;

    public EmailSession(String server, int port, final String username, final String password, Properties properties) throws MessagingException {
        Session thisSession;
        this.server = server;
        this.port = port;
        this.username = username;
        this.password = password;
        this.properties = properties;
        properties.put("mail.smtp.host", server);
        properties.put("mail.smtp.port", new Integer(port).toString());
        if (properties.get("mail.smtp.connectiontimeout") == null) {
            properties.put("mail.smtp.connectiontimeout", new Integer(60000));
        }
        if (properties.get("mail.smtp.timeout") == null) {
            properties.put("mail.smtp.timeout", new Integer(60000));
        }
        if (properties.get("mail.smtp.writetimeout") == null) {
            properties.put("mail.smtp.writetimeout", new Integer(60000));
        }
        if (username != null && username.length() > 0) {
            properties.put("mail.smtp.auth", "true");
        }
        if (properties.get("mail.smtp.starttls.enable") == null) {
            properties.put("mail.smtp.starttls.enable", "true");
        }
        this.session = thisSession = Session.getInstance((Properties)properties, (Authenticator)new Authenticator(){

            protected PasswordAuthentication getPasswordAuthentication() {
                return new PasswordAuthentication(username, password);
            }
        });
    }

    public void checkConnection() throws MessagingException {
    }

    public void send(List<String> to, String from, String subject, String body) throws MessagingException {
        MimeMessage message = new MimeMessage(this.session);
        message.setFrom((Address)new InternetAddress(from));
        for (String toValue : to) {
            message.addRecipient(Message.RecipientType.TO, (Address)new InternetAddress(toValue));
        }
        message.setSubject(subject);
        message.setText(body);
        Transport.send((Message)message);
    }

    public void close() throws MessagingException {
        this.session = null;
    }
}

