/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.crawler;

import org.apache.manifoldcf.core.interfaces.IThreadContext;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;
import org.apache.manifoldcf.core.interfaces.ThreadContextFactory;
import org.apache.manifoldcf.crawler.interfaces.IJobManager;
import org.apache.manifoldcf.crawler.interfaces.JobManagerFactory;
import org.apache.manifoldcf.crawler.interfaces.JobStatus;
import org.apache.manifoldcf.crawler.system.ManifoldCF;

public class WaitForJobInactive {
    public static final String _rcsid = "@(#)$Id: WaitForJobInactive.java 988245 2010-08-23 18:39:35Z kwright $";

    private WaitForJobInactive() {
    }

    public static void main(String[] args) {
        block10: {
            if (args.length != 1) {
                System.err.println("Usage: WaitForJobInactive <jobid>");
                System.exit(1);
            }
            String jobID = args[0];
            try {
                IThreadContext tc = ThreadContextFactory.make();
                ManifoldCF.initializeEnvironment(tc);
                IJobManager jobManager = JobManagerFactory.make(tc);
                while (true) {
                    JobStatus status;
                    if ((status = jobManager.getStatus(new Long(jobID))) == null) {
                        throw new ManifoldCFException("No such job: '" + jobID + "'");
                    }
                    int statusValue = status.getStatus();
                    switch (statusValue) {
                        case 0: {
                            System.out.println("Never run");
                            break block10;
                        }
                        case 5: {
                            System.out.println("OK");
                            break block10;
                        }
                        case 9: {
                            System.out.println("Error: " + status.getErrorText());
                            break block10;
                        }
                        default: {
                            ManifoldCF.sleep((long)10000L);
                            break;
                        }
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                System.exit(2);
            }
        }
    }
}

