/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.crawler.interfaces;

import java.util.ArrayList;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;

public class SortOrder {
    public static final String _rcsid = "@(#)$Id: SortOrder.java 988245 2010-08-23 18:39:35Z kwright $";
    public static final int SORT_ASCENDING = 0;
    public static final int SORT_DESCENDING = 1;
    protected ArrayList sortList = new ArrayList();

    public SortOrder() {
    }

    public SortOrder(String rep) throws ManifoldCFException {
        ParseBuffer pb = new ParseBuffer(rep);
        StringBuilder numBuffer = new StringBuilder();
        while (true) {
            int x;
            if ((x = pb.peekCharAt()) == -1) {
                throw new ManifoldCFException("Unexpected end");
            }
            char y = (char)x;
            pb.next();
            if (y == ':') break;
            numBuffer.append(y);
        }
        try {
            int numCount = Integer.parseInt(numBuffer.toString());
            for (int i = 0; i < numCount; ++i) {
                SortSpec ss = new SortSpec(pb);
                this.sortList.add(ss);
            }
        }
        catch (NumberFormatException e) {
            throw new ManifoldCFException("Bad number", (Throwable)e);
        }
    }

    public String toString() {
        StringBuilder output = new StringBuilder();
        output.append(Integer.toString(this.sortList.size()));
        output.append(":");
        int i = 0;
        while (i < this.sortList.size()) {
            SortSpec ss = (SortSpec)this.sortList.get(i++);
            output.append(ss.toString());
        }
        return output.toString();
    }

    public void clickColumn(String columnName) {
        SortSpec ss;
        int findIndex = -1;
        for (int i = 0; i < this.sortList.size(); ++i) {
            ss = (SortSpec)this.sortList.get(i);
            if (!ss.getColumn().equals(columnName)) continue;
            findIndex = i;
        }
        if (findIndex == -1) {
            this.addCriteria(columnName, 0);
        } else if (findIndex == 0) {
            ss = (SortSpec)this.sortList.get(findIndex);
            this.sortList.remove(findIndex);
            this.addCriteria(columnName, ss.getDirection() == 0 ? 1 : 0);
        } else {
            ss = (SortSpec)this.sortList.remove(findIndex);
            this.sortList.add(0, ss);
        }
    }

    public void addCriteria(String columnName, int order) {
        this.sortList.add(0, new SortSpec(columnName, order));
    }

    public int getCount() {
        return this.sortList.size();
    }

    public String getColumn(int i) {
        return ((SortSpec)this.sortList.get(i)).getColumn();
    }

    public int getDirection(int i) {
        return ((SortSpec)this.sortList.get(i)).getDirection();
    }

    public static class SortSpec {
        protected String column;
        protected int direction;

        public SortSpec(String column, int direction) {
            this.column = column;
            this.direction = direction;
        }

        public SortSpec(ParseBuffer pb) throws ManifoldCFException {
            int x = pb.peekCharAt();
            if (x == -1) {
                throw new ManifoldCFException("Unexpected end");
            }
            char y = (char)x;
            if (y == '+') {
                this.direction = 0;
            } else if (y == '-') {
                this.direction = 1;
            } else {
                throw new ManifoldCFException("Bad direction");
            }
            pb.next();
            StringBuilder sb = new StringBuilder();
            while (true) {
                if ((x = pb.peekCharAt()) == -1) {
                    throw new ManifoldCFException("Unexpected end");
                }
                y = (char)x;
                pb.next();
                if (y == '.') break;
                sb.append(y);
            }
            this.column = sb.toString();
        }

        public String getColumn() {
            return this.column;
        }

        public int getDirection() {
            return this.direction;
        }

        public String toString() {
            StringBuilder output = new StringBuilder();
            if (this.direction == 0) {
                output.append("+");
            } else {
                output.append("-");
            }
            output.append(this.column).append(".");
            return output.toString();
        }
    }

    public static class ParseBuffer {
        protected String value;
        protected int startPosition;

        public ParseBuffer(String value) {
            this.value = value;
            this.startPosition = 0;
        }

        public int peekCharAt() {
            if (this.startPosition == this.value.length()) {
                return -1;
            }
            return this.value.charAt(this.startPosition);
        }

        public void next() {
            if (this.startPosition < this.value.length()) {
                ++this.startPosition;
            }
        }
    }
}

