/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fonts;

import java.net.URL;
import java.util.Iterator;
import java.util.List;
import org.apache.fop.fonts.EmbedFontInfo;
import org.apache.fop.fonts.FontCache;
import org.apache.fop.fonts.FontEventListener;
import org.apache.fop.fonts.FontManager;
import org.apache.fop.fonts.FontResolver;
import org.apache.fop.fonts.autodetect.FontInfoFinder;

public class FontAdder {
    private FontEventListener listener;
    private FontResolver resolver;
    private FontManager manager;

    public FontAdder(FontManager manager, FontResolver resolver, FontEventListener listener) {
        this.manager = manager;
        this.resolver = resolver;
        this.listener = listener;
    }

    public void add(List fontURLList, List fontInfoList) {
        FontCache cache = this.manager.getFontCache();
        FontInfoFinder finder = new FontInfoFinder();
        finder.setEventListener(this.listener);
        Iterator iter = fontURLList.iterator();
        while (iter.hasNext()) {
            URL fontUrl = (URL)iter.next();
            EmbedFontInfo[] embedFontInfos = finder.find(fontUrl, this.resolver, cache);
            if (embedFontInfos == null) continue;
            int c = embedFontInfos.length;
            for (int i = 0; i < c; ++i) {
                EmbedFontInfo fontInfo = embedFontInfos[i];
                if (fontInfo == null) continue;
                fontInfoList.add(fontInfo);
            }
        }
    }
}

