/*
 * Decompiled with CFR 0.152.
 */
package com.github.sommeri.less4j.core.compiler.expressions;

import com.github.sommeri.less4j.core.ast.ASTCssNodeType;
import com.github.sommeri.less4j.core.ast.Expression;
import com.github.sommeri.less4j.core.ast.FunctionExpression;
import com.github.sommeri.less4j.core.ast.IdentifierExpression;
import com.github.sommeri.less4j.core.ast.NumberExpression;
import com.github.sommeri.less4j.core.compiler.expressions.CatchAllMultiParameterFunction;
import com.github.sommeri.less4j.core.compiler.expressions.TypesConversionUtils;
import com.github.sommeri.less4j.core.parser.HiddenTokenAwareTree;
import com.github.sommeri.less4j.core.problems.ProblemsHandler;
import java.util.List;

class IsUnit
extends CatchAllMultiParameterFunction {
    private final TypesConversionUtils utils = new TypesConversionUtils();

    IsUnit() {
    }

    @Override
    protected Expression evaluate(List<Expression> splitParameters, ProblemsHandler problemsHandler, FunctionExpression functionCall, HiddenTokenAwareTree token) {
        Expression expression = splitParameters.get(0);
        Expression unitExpression = splitParameters.get(1);
        String unit = this.utils.contentToString(unitExpression);
        if (expression.getType() != ASTCssNodeType.NUMBER || unit == null) {
            return new IdentifierExpression(functionCall.getUnderlyingStructure(), "false");
        }
        return this.isunit((NumberExpression)expression, unit, functionCall.getUnderlyingStructure());
    }

    private Expression isunit(NumberExpression expression, String unit, HiddenTokenAwareTree token) {
        String suffix = expression.getSuffix();
        String result = "true";
        if (suffix == null || unit.isEmpty() || !suffix.equals(unit)) {
            result = "false";
        }
        return new IdentifierExpression(token, result);
    }

    @Override
    protected boolean validateParameter(Expression parameter, int position, ProblemsHandler problemsHandler) {
        return true;
    }

    @Override
    protected int getMinParameters() {
        return 2;
    }

    @Override
    protected int getMaxParameters() {
        return 2;
    }

    @Override
    protected String getName() {
        return "isunit";
    }
}

